/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.inventory;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.common.capability.types.NBTInterface;
import dmr.DragonMounts.network.packets.ClearDragonInventoryPacket;
import dmr.DragonMounts.network.packets.RequestDragonInventoryPacket;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.worlddata.DragonWorldData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="dmr")
public class DragonInventoryHandler {
    public static Map<UUID, DragonInventory> clientSideInventories = new HashMap<UUID, DragonInventory>();

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking startTracking) {
        if (startTracking.getEntity().level.isClientSide()) {
            return;
        }
        Entity entity = startTracking.getTarget();
        if (entity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            DragonInventory dragonInventory = DragonInventoryHandler.getOrCreateInventory(dragon);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)startTracking.getEntity()), (CustomPacketPayload)new RequestDragonInventoryPacket(dragon.getDragonUUID(), dragonInventory.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void stopTracking(PlayerEvent.StopTracking stopTracking) {
        if (stopTracking.getEntity().level.isClientSide()) {
            return;
        }
        Entity entity = stopTracking.getTarget();
        if (entity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)stopTracking.getEntity()), (CustomPacketPayload)new ClearDragonInventoryPacket(dragon.getDragonUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static DragonInventory getOrCreateInventory(TameableDragonEntity dragon) {
        return DragonInventoryHandler.getOrCreateInventory(dragon.level, dragon.getDragonUUID());
    }

    public static DragonInventory getOrCreateInventory(Level level, UUID uuid) {
        if (uuid == null) {
            return new DragonInventory(level);
        }
        if (level == null) {
            throw new NullPointerException("Cannot get dragon inventory for null level. UUID: " + String.valueOf(uuid));
        }
        if (level.isClientSide()) {
            clientSideInventories.computeIfAbsent(uuid, id -> new DragonInventory(level));
            return clientSideInventories.get(uuid);
        }
        DragonWorldData data = DragonWorldData.getInstance(level);
        if (!data.dragonInventories.containsKey(uuid) || data.dragonInventories.get(uuid) == null) {
            DMR.LOGGER.debug("Creating new dragon inventory for {}", (Object)uuid);
            data.dragonInventories.put(uuid, new DragonInventory(level));
            data.setDirty();
        }
        if (data.dragonInventories.get(uuid) == null) {
            throw new NullPointerException("Dragon inventory is null for " + String.valueOf(uuid));
        }
        return data.dragonInventories.get(uuid);
    }

    public static class DragonInventory
    implements NBTInterface,
    ContainerListener {
        boolean isDirty = false;
        public static final int SADDLE_SLOT = 0;
        public static final int ARMOR_SLOT = 1;
        public static final int CHEST_SLOT = 2;
        public static final int INVENTORY_SIZE = 27;
        private final HolderLookup.Provider registryAccess;
        public SimpleContainer inventory = new SimpleContainer(this.getInventorySize());

        public DragonInventory(Level level) {
            this.registryAccess = level.registryAccess();
            this.inventory.addListener((ContainerListener)this);
        }

        public DragonInventory(HolderLookup.Provider registryAccess) {
            this.registryAccess = registryAccess;
            this.inventory.addListener((ContainerListener)this);
        }

        public int getInventorySize() {
            return 30;
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag compound = new CompoundTag();
            ListTag listtag = new ListTag();
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putByte("Slot", (byte)i);
                listtag.add((Object)itemstack.save(this.registryAccess, (Tag)compoundtag));
            }
            compound.put("Items", (Tag)listtag);
            return compound;
        }

        @Override
        public void readNBT(CompoundTag compound) {
            ListTag listtag = new ListTag();
            if (compound.contains("Items")) {
                listtag = compound.getList("Items", 10);
            }
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                int j = compoundtag.getByte("Slot") & 0xFF;
                if (j >= this.inventory.getContainerSize()) continue;
                this.inventory.setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess, (Tag)compoundtag).orElse(ItemStack.EMPTY));
            }
        }

        public void containerChanged(Container container) {
            this.setDirty(true);
        }

        @Generated
        public boolean isDirty() {
            return this.isDirty;
        }

        @Generated
        public void setDirty(boolean isDirty) {
            this.isDirty = isDirty;
        }
    }
}

