/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import com.mojang.serialization.DynamicOps;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.registry.ModCapabilities;
import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.entity.dragon.DragonMovementComponent;
import dmr.DragonMounts.server.worlddata.DragonWorldDataManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

abstract class DragonOwnershipComponent
extends DragonMovementComponent {
    protected static final EntityDataAccessor<Optional<GlobalPos>> wanderingPosDataAccessor = SynchedEntityData.defineId(DragonOwnershipComponent.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_GLOBAL_POS);
    protected static final EntityDataAccessor<Long> lastPoseChangeTickDataAccessor = SynchedEntityData.defineId(DragonOwnershipComponent.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    protected static final EntityDataAccessor<Boolean> orderedToSitDataAccessor = SynchedEntityData.defineId(DragonOwnershipComponent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    protected DragonOwnershipComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(orderedToSitDataAccessor, (Object)false);
        builder.define(wanderingPosDataAccessor, Optional.empty());
        builder.define(lastPoseChangeTickDataAccessor, (Object)0L);
    }

    public LivingEntity getOwner() {
        TameableDragonEntity dragon = (TameableDragonEntity)this;
        UUID uuid = dragon.getOwnerUUID();
        if (uuid != null) {
            for (Player player : dragon.level().players()) {
                if (!player.getUUID().equals(uuid)) continue;
                return player;
            }
        }
        return null;
    }

    public void setCustomName(Component pName) {
        super.setCustomName(pName);
        this.updateOwnerData();
    }

    public void updateOwnerData() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                DragonOwnerCapability handler = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
                if (handler.isBoundToWhistle(this.getDragon())) {
                    handler.setPlayerInstance(player);
                    handler.setDragonToWhistle(this.getDragon(), DragonWhistleHandler.getDragonSummonIndex(player, this.getDragon().getDragonUUID()));
                } else {
                    DragonWorldDataManager.addDragonHistory(this.getDragon());
                }
            }
        }
    }

    public void tamedFor(Player player, boolean successful) {
        if (successful) {
            this.setTame(true, true);
            this.getNavigation().stop();
            this.setTarget(null);
            this.setOwnerUUID(player.getUUID());
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            this.updateOwnerData();
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public boolean isTamedFor(Player player) {
        return this.isTame() && (this.isOwnedBy((LivingEntity)player) || Objects.equals(this.getOwnerUUID(), player.getUUID()));
    }

    public boolean isOrderedToSit() {
        return (Boolean)this.entityData.get(orderedToSitDataAccessor);
    }

    public void setOrderedToSit(boolean pOrderedToSit) {
        this.entityData.set(orderedToSitDataAccessor, (Object)pOrderedToSit);
        this.getNavigation().stop();
        this.setTarget(null);
        this.setInSittingPose(pOrderedToSit);
    }

    public void stopSitting() {
        this.setOrderedToSit(false);
        this.setInSittingPose(false);
        this.setPose(Pose.STANDING);
    }

    public void setInSittingPose(boolean sitting) {
        super.setInSittingPose(sitting);
        if (!sitting) {
            this.resetLastPoseChangeTickToFullStand(this.level().getGameTime());
        }
    }

    public boolean isRandomlySitting() {
        return this.isSitting() && !this.isOrderedToSit();
    }

    public void setRandomlySitting(boolean sit) {
        if (!this.isOrderedToSit()) {
            this.setInSittingPose(sit);
        }
    }

    public boolean isSitting() {
        return this.isInSittingPose();
    }

    public boolean isTamingItem(ItemStack stack) {
        List<Item> list = this.getBreed().getTamingItems();
        return !stack.isEmpty() && (list != null && !list.isEmpty() ? list.contains(stack.getItem()) : stack.is(ItemTags.FISHES));
    }

    public boolean hasWanderTarget() {
        if (this.getWanderTarget().isPresent()) {
            GlobalPos pos = this.getWanderTarget().get();
            return pos.dimension() == this.level.dimension();
        }
        return false;
    }

    public Optional<GlobalPos> getWanderTarget() {
        return (Optional)this.entityData.get(wanderingPosDataAccessor);
    }

    public void setWanderTarget(Optional<GlobalPos> pos) {
        this.entityData.set(wanderingPosDataAccessor, pos);
        if (pos.isEmpty() && this.getBrain().hasMemoryValue(ModMemoryModuleTypes.SHOULD_WANDER.get())) {
            this.getBrain().eraseMemory(ModMemoryModuleTypes.SHOULD_WANDER.get());
        } else if (pos.isPresent()) {
            this.getBrain().setMemory(ModMemoryModuleTypes.SHOULD_WANDER.get(), (Object)true);
            this.stopSitting();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("OrderedToSit", this.isOrderedToSit());
        this.getWanderTarget().flatMap(p_337878_ -> GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p_337878_).resultOrPartial(System.err::println)).ifPresent(p_219756_ -> compound.put("wanderingPosition", p_219756_));
        compound.putLong("LastPoseTick", ((Long)this.entityData.get(lastPoseChangeTickDataAccessor)).longValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("OrderedToSit")) {
            this.setOrderedToSit(compound.getBoolean("OrderedToSit"));
        }
        if (compound.contains("wanderingPosition")) {
            Optional wanderTarget = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("wanderingPosition")).resultOrPartial(System.err::println);
            this.setWanderTarget(wanderTarget);
        }
    }

    public boolean canChangePose() {
        return this.wouldNotSuffocateAtTargetPose(this.isInSittingPose() ? Pose.STANDING : Pose.SITTING);
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(lastPoseChangeTickDataAccessor));
    }

    public void resetLastPoseChangeTickToFullStand(long lastPoseChangedTick) {
        this.resetLastPoseChangeTick(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public void resetLastPoseChangeTick(long lastPoseChangeTick) {
        this.entityData.set(lastPoseChangeTickDataAccessor, (Object)lastPoseChangeTick);
    }
}

