/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.packets.RequestDragonInventoryPacket;
import dmr.DragonMounts.server.container.DragonContainerMenu;
import dmr.DragonMounts.server.entity.dragon.DragonCombatComponent;
import dmr.DragonMounts.server.inventory.DragonInventoryHandler;
import dmr.DragonMounts.server.items.DragonArmorItem;
import dmr.DragonMounts.server.items.DragonSpawnEgg;
import dmr.DragonMounts.types.armor.DragonArmor;
import dmr.DragonMounts.util.PlayerStateUtils;
import io.netty.buffer.Unpooled;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;

abstract class DragonInventoryComponent
extends DragonCombatComponent {
    protected static final EntityDataAccessor<Boolean> idChestDataAccessor = SynchedEntityData.defineId(DragonInventoryComponent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> saddledDataAccessor = SynchedEntityData.defineId(DragonInventoryComponent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ResourceLocation ARMOR_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"armor_attribute");

    protected DragonInventoryComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(saddledDataAccessor, (Object)false);
        builder.define(idChestDataAccessor, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("saddle", this.isSaddled());
        compound.putBoolean("chest", this.hasChest());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("saddle")) {
            this.setSaddled(compound.getBoolean("saddle"));
        }
        if (compound.contains("chest")) {
            this.setChest(compound.getBoolean("chest"));
        }
        if (compound.contains("Items")) {
            ListTag listtag = compound.getList("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                int j = compoundtag.getByte("Slot") & 0xFF;
                if (j >= this.getInventory().getContainerSize()) continue;
                this.getInventory().setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag).orElse(ItemStack.EMPTY));
            }
        }
    }

    public void equipChest(ItemStack stack, SoundSource source) {
        this.getInventory().setItem(2, stack);
        this.setChest(true);
    }

    public void equipSaddle(ItemStack stack, SoundSource source) {
        this.getDragon().setSaddled(true);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.HORSE_SADDLE, this.getSoundSource(), 1.0f, 1.0f);
        this.getInventory().setItem(0, stack);
    }

    public ItemStack getPickedResult(HitResult target) {
        return DragonSpawnEgg.create(this.getBreed());
    }

    public void equipArmor(Player pPlayer, ItemStack pArmor) {
        if (!this.isWearingArmor()) {
            this.setItemSlot(EquipmentSlot.BODY, pArmor.copyWithCount(1));
            if (!pPlayer.getAbilities().instabuild) {
                pArmor.shrink(1);
            }
            this.setArmor();
        }
    }

    public void setArmor() {
        ItemStack itemstack = this.getBodyArmorItem();
        if (!this.level().isClientSide) {
            int i;
            DragonArmor armor;
            this.getAttribute(Attributes.ARMOR).removeModifier(ARMOR_MODIFIER);
            if (this.isArmor(itemstack) && (armor = DragonArmor.getArmorType(itemstack)) != null && (i = armor.getProtection()) != 0) {
                this.getAttribute(Attributes.ARMOR).addTransientModifier(new AttributeModifier(ARMOR_MODIFIER, (double)i, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    public boolean isArmor(ItemStack pStack) {
        return pStack.getItem() instanceof DragonArmorItem;
    }

    public void containerChanged(Container pContainer) {
        this.setArmor();
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new RequestDragonInventoryPacket(this.getDragon().getDragonUUID(), this.getDragonInventory().writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        pPlayer.openMenu((MenuProvider)new SimpleMenuProvider((pId, pInventory, pPlayer1) -> this.createMenu(pId, pInventory), this.getDisplayName()), buf -> buf.writeInt(this.getId()));
    }

    private DragonContainerMenu createMenu(int pId, Inventory pInventory) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeInt(this.getId());
        return new DragonContainerMenu(pId, pInventory, buffer);
    }

    public void dropEquipment() {
        Player player;
        DragonOwnerCapability capability;
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player && (capability = PlayerStateUtils.getHandler(player = (Player)livingEntity)).isBoundToWhistle(this.getDragon())) {
            return;
        }
        super.dropEquipment();
        for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = this.getInventory().getItem(i);
            DMR.LOGGER.warn("Dropping item: {}", (Object)itemstack);
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public boolean isWearingArmor() {
        return !this.getBodyArmorItem().isEmpty();
    }

    public DragonInventoryHandler.DragonInventory getDragonInventory() {
        return DragonInventoryHandler.getOrCreateInventory(this.level, this.getDragon().getDragonUUID());
    }

    public SimpleContainer getInventory() {
        return this.getDragonInventory().inventory;
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.getInventory() != pInventory;
    }

    public void updateContainerEquipment() {
        if (!this.level().isClientSide) {
            this.setSaddled(!this.getInventory().getItem(0).isEmpty() && this.getInventory().getItem(0).is(Items.SADDLE));
            this.setChest(!this.getInventory().getItem(2).isEmpty() && (this.getInventory().getItem(2).is(Items.CHEST) || this.getInventory().getItem(2).is(Items.ENDER_CHEST)));
        }
    }

    public boolean inventoryEmpty() {
        for (int i = 3; i < this.getInventory().getContainerSize(); ++i) {
            if (this.getInventory().getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(saddledDataAccessor) != false || this.getInventory().getItem(0).is(Items.SADDLE);
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(saddledDataAccessor, (Object)saddled);
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isHatchling() && this.isTame();
    }

    public boolean hasChest() {
        return (Boolean)this.entityData.get(idChestDataAccessor) != false || this.getInventory().getItem(2).is(Items.ENDER_CHEST) || this.getInventory().getItem(2).is(Items.CHEST);
    }

    public void setChest(boolean hasChest) {
        this.entityData.set(idChestDataAccessor, (Object)hasChest);
    }

    public ItemStack getBodyArmorItem() {
        return this.getInventory().getItem(1);
    }

    public void setBodyArmorItem(ItemStack stack) {
        this.getInventory().setItem(1, stack);
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.BODY -> this.getBodyArmorItem();
            default -> super.getItemBySlot(slot);
        };
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.verifyEquippedItem(stack);
        if (slot == EquipmentSlot.BODY) {
            ItemStack itemstack = this.getItemBySlot(slot);
            this.setBodyArmorItem(stack);
            this.onEquipItem(slot, itemstack, stack);
        }
    }
}

