/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.server.ai.DragonAI;
import dmr.DragonMounts.server.entity.dragon.DragonBreedableComponent;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

abstract class DragonCombatComponent
extends DragonBreedableComponent {
    protected DragonCombatComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public boolean hurt(DamageSource src, float amount) {
        Entity entity;
        if (this.isInvulnerableTo(src)) {
            return false;
        }
        this.getDragon().stopSitting();
        boolean flag = super.hurt(src, amount);
        if (flag && (entity = src.getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            DragonAI.wasHurtBy(this.getDragon(), attacker);
        }
        return flag;
    }

    public boolean isInvulnerableTo(DamageSource src) {
        Entity srcEnt = src.getEntity();
        if (srcEnt != null && (srcEnt == this || this.hasPassenger(srcEnt))) {
            return true;
        }
        Level level = this.level();
        if (src == level.damageSources().dragonBreath() || src == level.damageSources().cactus() || src == level.damageSources().inWall()) {
            return true;
        }
        return this.getDragon().getBreed().getImmunities().contains(src.getMsgId()) || super.isInvulnerableTo(src);
    }

    public boolean doHurtTarget(Entity entityIn) {
        Level level;
        DamageSource damageSource = this.level().damageSources().mobAttack((LivingEntity)this);
        boolean attacked = entityIn.hurt(damageSource, (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
        if (attacked && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entityIn, (DamageSource)damageSource);
        }
        if (attacked) {
            this.triggerAnim("head-controller", "bite");
        }
        return attacked;
    }

    public boolean canAttack(LivingEntity target) {
        return !this.isHatchling() && !this.hasControllingPassenger() && super.canAttack(target);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)target;
            LivingEntity tamableOwner = tameable.getOwner();
            return !Objects.equals(tamableOwner, owner);
        }
        return true;
    }

    public void setTarget(LivingEntity target) {
        super.setTarget(target);
        this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        if (target != null) {
            this.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
        }
    }

    public boolean fireImmune() {
        return super.fireImmune() || this.getDragon().getBreed() != null && this.getDragon().getBreed().getImmunities().contains("onFire");
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return !this.getDragon().canFly() && super.causeFallDamage(pFallDistance, pMultiplier, pSource);
    }

    public void swing(InteractionHand hand) {
        this.playSound(this.getDragon().getAttackSound(), 1.0f, 0.7f);
        super.swing(hand);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.getBreed().getDeathLootTable() != null ? ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getBreed().getDeathLootTable()) : super.getDefaultLootTable();
    }

    public double getHealthRelative() {
        return (double)this.getHealth() / (double)this.getMaxHealth();
    }

    public int getMaxDeathTime() {
        return 60;
    }

    protected void tickDeath() {
        this.ejectPassengers();
        this.setDeltaMovement(Vec3.ZERO);
        this.setYRot(this.yRotO);
        this.setYHeadRot(this.yHeadRotO);
        if (this.deathTime >= this.getMaxDeathTime()) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        ++this.deathTime;
    }
}

