/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.packets.CompleteDataSync;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModEntities;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.worlddata.DragonWorldData;
import dmr.DragonMounts.server.worlddata.DragonWorldDataManager;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class DMRCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)Commands.literal((String)"dmr").requires(source -> source.hasPermission(2));
        LiteralArgumentBuilder spawnRegular = (LiteralArgumentBuilder)baseCommand.then(Commands.literal((String)"spawn").then(Commands.literal((String)"regular").then(((RequiredArgumentBuilder)Commands.argument((String)"breed", (ArgumentType)StringArgumentType.word()).suggests(DMRCommand::getBreeds).executes(context -> DMRCommand.spawnDragon((CommandSourceStack)context.getSource(), (String)context.getArgument("breed", String.class), ((CommandSourceStack)context.getSource()).getPosition(), new CompoundTag()))).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(context -> DMRCommand.spawnDragon((CommandSourceStack)context.getSource(), (String)context.getArgument("breed", String.class), Vec3Argument.getVec3((CommandContext)context, (String)"pos"), new CompoundTag()))).then(Commands.argument((String)"nbt", (ArgumentType)StringArgumentType.greedyString()).executes(context -> DMRCommand.spawnDragon((CommandSourceStack)context.getSource(), (String)context.getArgument("breed", String.class), Vec3Argument.getVec3((CommandContext)context, (String)"pos"), CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt"))))))));
        LiteralArgumentBuilder spawnHybrid = (LiteralArgumentBuilder)baseCommand.then(Commands.literal((String)"spawn").then(Commands.literal((String)"hybrid").then(Commands.argument((String)"parent 1", (ArgumentType)StringArgumentType.word()).suggests(DMRCommand::getBreeds).then(((RequiredArgumentBuilder)Commands.argument((String)"parent 2", (ArgumentType)StringArgumentType.word()).suggests(DMRCommand::getBreeds).executes(context -> DMRCommand.spawnDragon((CommandSourceStack)context.getSource(), String.format("hybrid_%s_%s", context.getArgument("parent 1", String.class), context.getArgument("parent 2", String.class)), ((CommandSourceStack)context.getSource()).getPosition(), new CompoundTag()))).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(context -> DMRCommand.spawnDragon((CommandSourceStack)context.getSource(), String.format("hybrid_%s_%s", context.getArgument("parent 1", String.class), context.getArgument("parent 2", String.class)), Vec3Argument.getVec3((CommandContext)context, (String)"pos"), new CompoundTag()))).then(Commands.argument((String)"nbt", (ArgumentType)StringArgumentType.greedyString()).executes(context -> DMRCommand.spawnDragon((CommandSourceStack)context.getSource(), String.format("hybrid_%s_%s", context.getArgument("parent 1", String.class), context.getArgument("parent 2", String.class)), Vec3Argument.getVec3((CommandContext)context, (String)"pos"), CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt")))))))));
        LiteralArgumentBuilder recall = (LiteralArgumentBuilder)baseCommand.then(Commands.literal((String)"recall").then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)UuidArgument.uuid()).suggests((context, builder) -> {
            DragonWorldDataManager.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).dragonHistory.values().stream().sorted(Comparator.comparing(DragonWorldData.DragonHistory::time)).forEach(v -> builder.suggest(v.id().toString(), (Message)Component.translatable((String)"dmr.commands.dragon_recall.suggest", (Object[])new Object[]{v.dragonName().copy().withStyle(ChatFormatting.AQUA), Component.literal((String)v.playerName()).withStyle(ChatFormatting.GRAY), Component.literal((String)DMRCommand.getTimeAgo(v.time())).withStyle(ChatFormatting.GRAY)})));
            return builder.buildFuture();
        }).executes(context -> DMRCommand.runRecall((CommandSourceStack)context.getSource(), (UUID)context.getArgument("id", UUID.class), ((CommandSourceStack)context.getSource()).getPosition()))).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(context -> DMRCommand.runRecall((CommandSourceStack)context.getSource(), (UUID)context.getArgument("id", UUID.class), Vec3Argument.getVec3((CommandContext)context, (String)"pos"))))));
        LiteralArgumentBuilder clearWhistle = (LiteralArgumentBuilder)baseCommand.then(Commands.literal((String)"clear_whistle").then(Commands.argument((String)"color", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (DyeColor color : DyeColor.values()) {
                builder.suggest(color.getName());
            }
            return builder.buildFuture();
        }).executes(ctx -> DMRCommand.runClearWhistle((CommandSourceStack)ctx.getSource(), DyeColor.byName((String)((String)ctx.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE)))));
        commandDispatcher.register(spawnRegular);
        commandDispatcher.register(spawnHybrid);
        commandDispatcher.register(recall);
        commandDispatcher.register(clearWhistle);
    }

    private static String getTimeAgo(long timestampMs) {
        long diff = System.currentTimeMillis() - timestampMs;
        if (diff < 0L) {
            return "";
        }
        if (diff < 60000L) {
            return diff / 1000L + "s";
        }
        if (diff < 3600000L) {
            return diff / 60000L + "m";
        }
        if (diff < 86400000L) {
            return diff / 3600000L + "h";
        }
        return diff / 86400000L + "d";
    }

    private static int spawnDragon(CommandSourceStack source, String breedName, Vec3 position, CompoundTag nbt) {
        if (!DragonBreedsRegistry.hasDragonBreed(breedName)) {
            source.sendFailure((Component)Component.translatable((String)"dmr.commands.dragon_spawn.invalid_breed", (Object[])new Object[]{breedName}));
            return 0;
        }
        IDragonBreed breed = DragonBreedsRegistry.getDragonBreed(breedName);
        ServerLevel level = source.getLevel();
        TameableDragonEntity dragonEntity = (TameableDragonEntity)ModEntities.DRAGON_ENTITY.get().create((Level)level);
        if (dragonEntity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = dragonEntity;
            dragon.load(nbt);
            dragon.setPos(position.x, position.y, position.z);
            dragon.setBreed(breed);
            level.addFreshEntity((Entity)dragon);
        }
        source.sendSuccess(() -> Component.translatable((String)"dmr.commands.dragon_spawn.success", (Object[])new Object[]{breed.getName()}), true);
        return 1;
    }

    private static int runRecall(CommandSourceStack source, UUID id, Vec3 position) {
        CompoundTag nbt;
        DragonWorldData.DragonHistory history = DragonWorldDataManager.getDragonHistory((Level)source.getLevel(), id);
        CompoundTag compoundTag = nbt = history != null ? history.compoundTag() : null;
        if (nbt != null) {
            Entity entity;
            ServerLevel level = source.getLevel();
            Optional type = EntityType.by((CompoundTag)nbt);
            if (type.isPresent() && (entity = ((EntityType)type.get()).create((Level)level)) instanceof TameableDragonEntity) {
                TameableDragonEntity dragon = (TameableDragonEntity)entity;
                dragon.load(nbt);
                dragon.setUUID(id);
                dragon.setPos(position.x, position.y, position.z);
                dragon.setHealth(Math.max(1.0f, dragon.getHealth()));
                level.addFreshEntity((Entity)dragon);
            }
            source.sendSuccess(() -> Component.translatable((String)"dmr.commands.dragon_recall.success", (Object[])new Object[]{id.toString()}), true);
        } else {
            source.sendFailure((Component)Component.translatable((String)"dmr.commands.dragon_recall.failure", (Object[])new Object[]{id.toString()}));
        }
        return 1;
    }

    private static int runClearWhistle(CommandSourceStack source, DyeColor color) {
        DragonOwnerCapability handler = PlayerStateUtils.getHandler((Player)source.getPlayer());
        handler.dragonNBTs.remove(color.getId());
        handler.dragonInstances.remove(color.getId());
        handler.respawnDelays.remove(color.getId());
        PacketDistributor.sendToPlayer((ServerPlayer)source.getPlayer(), (CustomPacketPayload)new CompleteDataSync((Player)source.getPlayer()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        source.sendSuccess(() -> Component.translatable((String)"dmr.commands.clear_whistle.success", (Object[])new Object[]{Component.translatable((String)("color.minecraft." + color.getName()))}), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> getBreeds(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        DragonBreedsRegistry.getDragonBreeds().stream().filter(breed -> !breed.isHybrid()).forEach(breed -> builder.suggest(breed.getId(), (Message)breed.getName()));
        return builder.buildFuture();
    }
}

