/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.blocks;

import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModBlockEntities;
import dmr.DragonMounts.server.blockentities.DMRBlankEggBlockEntity;
import dmr.DragonMounts.server.blocks.DMREggBlock;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlankEggBlock
extends DragonEggBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public BlankEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new DMRBlankEggBlockEntity(pPos, pState);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level _level, BlockState _state, BlockEntityType<T> type) {
        return type != ModBlockEntities.BLANK_EGG_BLOCK_ENTITY.get() ? null : (BlockEntityTicker)BlankEggBlock.cast((level, pos, state, be) -> be.tick(level, pos, state));
    }

    private static <F extends BlockEntityTicker<DMRBlankEggBlockEntity>, T> T cast(F from) {
        return (T)from;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public BlockState updateShape(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, pDirection, pNeighborState, level, pCurrentPos, pNeighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        return (BlockState)super.getStateForPlacement(p_196258_1_).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(p_196258_1_.getLevel().getFluidState(p_196258_1_.getClickedPos()).getType() == Fluids.WATER));
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource random) {
        DMRBlankEggBlockEntity e;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof DMRBlankEggBlockEntity && (e = (DMRBlankEggBlockEntity)blockEntity).getTargetBreedId() != null && !e.getTargetBreedId().isEmpty()) {
            for (int i = 0; i < random.nextIntBetweenInclusive(1, 3); ++i) {
                this.addHatchingParticles(DragonBreedsRegistry.getDragonBreed(e.getTargetBreedId()), pLevel, pPos, random);
            }
        }
    }

    public void addHatchingParticles(IDragonBreed breed, Level level, BlockPos pos, RandomSource random) {
        double px = (double)pos.getX() + random.nextDouble();
        double py = (double)pos.getY() + random.nextDouble();
        double pz = (double)pos.getZ() + random.nextDouble();
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        ParticleOptions particle = DMREggBlock.getHatchingParticles(breed, random);
        DMREggBlock.spawnHatchingParticle(level, pos, random, px, py, pz, ox, oy, oz, particle);
    }

    public void teleport(BlockState state, Level level, BlockPos pos) {
    }
}

