/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.sensors;

import dmr.DragonMounts.data.EntityTagProvider;
import dmr.DragonMounts.server.entity.DragonAgroState;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class DragonAttackablesSensor
extends NearestVisibleLivingEntitySensor {
    protected boolean isMatchingEntity(LivingEntity attacker, LivingEntity target) {
        Player player;
        TameableDragonEntity dragon = (TameableDragonEntity)attacker;
        boolean isNotAllied = TargetingConditions.forCombat().selector(s -> !s.isAlliedTo((Entity)dragon) && (!dragon.isTame() || dragon.getOwner() != null && !s.isAlliedTo((Entity)dragon.getOwner()))).test(attacker, target);
        LivingEntity livingEntity = dragon.getOwner();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getLastHurtMob() == target && !isNotAllied) {
            return true;
        }
        if (target instanceof TameableDragonEntity) {
            TameableDragonEntity otherDragon = (TameableDragonEntity)target;
            if (dragon.getSpawnGroupId() == otherDragon.getSpawnGroupId()) {
                return false;
            }
            if (!otherDragon.isTame() && !dragon.isTame()) {
                return true;
            }
        }
        EntityPredicate predicate = EntityPredicate.Builder.entity().of(dragon.isTame() ? EntityTagProvider.DRAGON_HUNTING_TARGET : EntityTagProvider.WILD_DRAGON_HUNTING_TARGET).build();
        boolean predicateMatches = predicate.matches((ServerLevel)dragon.level, target.position(), (Entity)target);
        boolean canHunt = !dragon.isTame() || dragon.getAgroState() == DragonAgroState.AGGRESSIVE;
        return this.isClose(attacker, target) && Sensor.isEntityAttackable((LivingEntity)attacker, (LivingEntity)target) && isNotAllied && predicateMatches && canHunt;
    }

    private boolean isClose(LivingEntity attacker, LivingEntity target) {
        return target.distanceToSqr((Entity)attacker) <= (((TameableDragonEntity)attacker).isTame() ? 16.0 : 64.0);
    }

    protected MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }
}

