/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.behaviours;

import dmr.DragonMounts.server.ai.behaviours.BehaviorWrapper;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorFactory {
    @SafeVarargs
    public static <E extends LivingEntity> BehaviorWrapper<E> withCondition(Predicate<E> condition, BehaviorControl<? super E> ... behaviors) {
        return new BehaviorWrapper<E>(condition, behaviors);
    }

    @SafeVarargs
    public static <E extends LivingEntity> BehaviorWrapper<E> withMemoryRequirements(Map<MemoryModuleType<?>, MemoryStatus> memoryRequirements, BehaviorControl<? super E> ... behaviors) {
        return new BehaviorWrapper<E>(memoryRequirements, behaviors);
    }

    @SafeVarargs
    public static <E extends LivingEntity> BehaviorWrapper<E> withConditionAndMemory(Predicate<E> condition, Map<MemoryModuleType<?>, MemoryStatus> memoryRequirements, BehaviorControl<? super E> ... behaviors) {
        return new BehaviorWrapper<E>(condition, memoryRequirements, behaviors);
    }

    @SafeVarargs
    public static <E extends LivingEntity> BehaviorWrapper<E> withPolicies(Predicate<E> condition, GateBehavior.OrderPolicy orderPolicy, GateBehavior.RunningPolicy runningPolicy, BehaviorControl<? super E> ... behaviors) {
        return new BehaviorWrapper<E>(condition, orderPolicy, runningPolicy, behaviors);
    }

    @SafeVarargs
    public static <E extends LivingEntity> BehaviorWrapper<E> withGoals(Predicate<E> condition, Function<TameableDragonEntity, Goal> ... goalFactories) {
        return new BehaviorWrapper<E>(condition, goalFactories);
    }
}

