/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.registry;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.registry.DragonArmorRegistry;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.server.items.DMRDevItem;
import dmr.DragonMounts.server.items.DragonArmorItem;
import dmr.DragonMounts.server.items.DragonEggItemBlock;
import dmr.DragonMounts.server.items.DragonSpawnEgg;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import dmr.DragonMounts.types.armor.DragonArmor;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"dmr");
    public static Supplier<CreativeModeTab> MOD_HYBRIDS_DEV_TAB;
    public static Supplier<CreativeModeTab> MOD_TESTING_DEV_TAB;
    public static final Supplier<CreativeModeTab> MOD_TAB;

    public static void init() {
        if (DMR.DEBUG) {
            MOD_HYBRIDS_DEV_TAB = CREATIVE_MODE_TABS.register("dragon_mounts_hybrids_dev", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get())).title((Component)Component.literal((String)"DMR Hybrid eggs")).displayItems((enabledFeatures, entries) -> {
                List<IDragonBreed> breeds = new ArrayList<IDragonBreed>(DragonBreedsRegistry.getDragonBreeds()).stream().filter(IDragonBreed::isHybrid).sorted(Comparator.comparing(IDragonBreed::getId)).toList();
                for (IDragonBreed type : breeds) {
                    entries.accept(DragonEggItemBlock.getDragonEggStack(type));
                }
                for (IDragonBreed type : breeds) {
                    entries.accept(DragonSpawnEgg.create(type));
                }
            }).build());
            MOD_TESTING_DEV_TAB = CREATIVE_MODE_TABS.register("dragon_mounts_testing_dev", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get())).title((Component)Component.literal((String)"DMR Testing items")).displayItems((enabledFeatures, entries) -> ModItems.ITEMS.getEntries().forEach(supplier -> {
                Item item = (Item)supplier.get();
                if (item instanceof DMRDevItem) {
                    entries.accept(item.getDefaultInstance());
                }
            })).build());
        }
    }

    static {
        MOD_TAB = CREATIVE_MODE_TABS.register("dragon_mounts", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get())).title((Component)Component.translatable((String)"itemGroup.dragon_mounts")).displayItems((enabledFeatures, entries) -> {
            entries.accept(ModItems.BLANK_EGG_BLOCK_ITEM.get().getDefaultInstance());
            List<IDragonBreed> breeds = DragonBreedsRegistry.getDragonBreeds();
            for (IDragonBreed type : breeds) {
                if (type.isHybrid()) continue;
                entries.accept(DragonEggItemBlock.getDragonEggStack(type));
                for (IDragonBreed.Variant variant : type.getVariants()) {
                    entries.accept(DragonEggItemBlock.getDragonEggStack(type, variant));
                }
            }
            for (IDragonBreed type : breeds) {
                if (type.isHybrid()) continue;
                entries.accept(DragonSpawnEgg.create(type));
                for (IDragonBreed.Variant variant : type.getVariants()) {
                    entries.accept(DragonSpawnEgg.create(type, variant));
                }
            }
            ArrayList<DragonArmor> armors = new ArrayList<DragonArmor>(DragonArmorRegistry.getDragonArmors());
            armors.sort(Comparator.comparing(DragonArmor::getProtection));
            for (DragonArmor armor : armors) {
                entries.accept(DragonArmorItem.getArmorStack(armor));
            }
            for (DyeColor color : DyeColor.values()) {
                entries.accept(DragonWhistleItem.getWhistleItem(color));
            }
        }).build());
    }
}

