/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.registry;

import com.google.common.collect.ImmutableMap;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.registry.ModCriterionTriggers;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.server.advancement.HatchTrigger;
import dmr.DragonMounts.server.items.DragonEggItemBlock;
import dmr.DragonMounts.server.items.DragonSpawnEgg;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;

public class ModAdvancements {
    public static void init(ServerLevel level) {
        ServerAdvancementManager manager = level.getServer().getAdvancements();
        HashMap map = new HashMap();
        Consumer<AdvancementHolder> register = holder -> {
            map.put(holder.id(), holder);
            manager.tree().addAll(List.of(holder));
        };
        HashMap<ResourceLocation, AdvancementHolder> origMap = new HashMap<ResourceLocation, AdvancementHolder>(manager.advancements);
        AdvancementHolder main = manager.get(DMR.id("main"));
        ArrayList<ItemPredicate> hybridStacks = new ArrayList<ItemPredicate>();
        for (IDragonBreed iDragonBreed : DragonBreedsRegistry.getDragonBreeds()) {
            if (!iDragonBreed.isHybrid() || iDragonBreed.getLootTable().isEmpty()) continue;
            ItemPredicate predicate = ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get()}).hasComponents(DataComponentPredicate.builder().expect(ModComponents.DRAGON_BREED.get(), (Object)iDragonBreed.getId()).build()).build();
            hybridStacks.add(predicate);
        }
        AdvancementHolder findHybrid = Advancement.Builder.advancement().parent(main).display(DragonEggItemBlock.getDragonEggStack(DragonBreedsRegistry.getDragonBreed("amethyst")), (Component)Component.translatable((String)"dmr.advancements.find_hybrid_egg.title"), (Component)Component.translatable((String)"dmr.advancements.find_hybrid_egg.description"), null, AdvancementType.TASK, true, true, false).addCriterion("obtained_hybrid_egg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])hybridStacks.toArray(new ItemPredicate[0]))).build(DMR.id("find_hybrid"));
        origMap.put(DMR.id("find_hybrid"), findHybrid);
        for (IDragonBreed breed : DragonBreedsRegistry.getDragonBreeds()) {
            if (breed.isHybrid() || breed.getLootTable().isEmpty()) continue;
            AdvancementHolder egg = Advancement.Builder.advancement().parent(manager.get(DMR.id("find_egg"))).display(DragonEggItemBlock.getDragonEggStack(breed), (Component)Component.translatable((String)"dmr.advancements.dragon_egg.title", (Object[])new Object[]{Component.translatable((String)("block.dmr.dragon_egg." + breed.getId()))}), (Component)Component.translatable((String)"dmr.advancements.dragon_egg.description", (Object[])new Object[]{Component.translatable((String)("block.dmr.dragon_egg." + breed.getId()))}), null, AdvancementType.TASK, true, true, true).addCriterion("obtained_dragon_egg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get()}).hasComponents(DataComponentPredicate.builder().expect(ModComponents.DRAGON_BREED.get(), (Object)breed.getId()).build()).build()})).build(DMR.id("dragon_egg_" + breed.getId()));
            AdvancementHolder hatch = Advancement.Builder.advancement().parent(egg).display(DragonSpawnEgg.create(breed), (Component)Component.translatable((String)"dmr.advancements.hatch_egg.title", (Object[])new Object[]{Component.translatable((String)("dmr.dragon_breed." + breed.getId()))}), (Component)Component.translatable((String)"dmr.advancements.hatch_egg.description", (Object[])new Object[]{Component.translatable((String)("dmr.dragon_breed." + breed.getId()))}), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("hatch_dragon_egg", new Criterion((CriterionTrigger)ModCriterionTriggers.HATCH_TRIGGER.get(), (CriterionTriggerInstance)HatchTrigger.HatchTriggerInstance.test(breed.getId()))).build(DMR.id("hatch_egg_" + breed.getId()));
            register.accept(egg);
            register.accept(hatch);
        }
        HashMap hashMap = new HashMap(origMap);
        map.keySet().forEach(hashMap::remove);
        hashMap.putAll(map);
        manager.advancements = ImmutableMap.builder().putAll(hashMap).build();
        for (AdvancementNode advancementnode : manager.tree().roots()) {
            if (!advancementnode.holder().id().getNamespace().equals("dmr") || !advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run((AdvancementNode)advancementnode);
        }
        for (PlayerAdvancements playeradvancements : level.getServer().getPlayerList().advancements.values()) {
            playeradvancements.reload(level.getServer().getPlayerList().getServer().getAdvancements());
        }
    }
}

