/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.registry.ModCriterionTriggers;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonAttackPacket
extends AbstractMessage<DragonAttackPacket> {
    private static final StreamCodec<FriendlyByteBuf, DragonAttackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonAttackPacket::getEntityId, DragonAttackPacket::new);
    private final int entityId;

    DragonAttackPacket() {
        this.entityId = -1;
    }

    public DragonAttackPacket(int entityId) {
        this.entityId = entityId;
    }

    @Override
    protected String getTypeName() {
        return "dragon_attack";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonAttackPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
        Entity entity = player.level.getEntity(this.entityId);
        if (entity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            dragon.swing(InteractionHand.MAIN_HAND);
            dragon.triggerAnim("head-controller", "bite");
            EntityDimensions dimensions = dragon.getDimensions(dragon.getPose());
            float degrees = Mth.wrapDegrees((float)player.yBodyRot);
            double yawRadians = -Math.toRadians(degrees);
            double f4 = Math.sin(yawRadians);
            double f5 = Math.cos(yawRadians);
            Vec3 lookVector = new Vec3(f4 * (double)dimensions.width() * 2.0, 0.0, f5 * (double)dimensions.width() * 2.0);
            AABB offsetAabb = dragon.getBoundingBox().move(lookVector).inflate(2.0, 5.0, 2.0);
            List entities = dragon.level.getNearbyEntities(LivingEntity.class, TargetingConditions.forCombat().selector(arg_0 -> ((Player)player).canAttack(arg_0)).selector(s -> !s.isAlliedTo((Entity)player)), (LivingEntity)player, offsetAabb);
            LivingEntity target = entities.stream().filter(e -> e != dragon && e != player).findFirst().orElse(null);
            if (target != null && dragon.doHurtTarget((Entity)target) && target.isDeadOrDying() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriterionTriggers.DEFEAT_WITH_DRAGON.get().trigger(serverPlayer);
            }
        }
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }
}

