/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.common.capability;

import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.network.packets.DragonNBTSync;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class DragonOwnerCapability
implements INBTSerializable<CompoundTag> {
    private Player playerInstance;
    public Long lastCall;
    public int dragonsHatched;
    public ConcurrentHashMap<Integer, UUID> lastSummons = new ConcurrentHashMap();
    public ConcurrentHashMap<Integer, Integer> respawnDelays = new ConcurrentHashMap();
    public ConcurrentHashMap<Integer, CompoundTag> dragonNBTs = new ConcurrentHashMap();
    public ConcurrentHashMap<Integer, DragonWhistleHandler.DragonInstance> dragonInstances = new ConcurrentHashMap();
    public boolean shouldDismount;
    public boolean cameraFlight = true;
    public boolean alternateDismount = true;

    public TameableDragonEntity createDragonEntity(Player player, Level world, int index) {
        Entity entity;
        Optional type;
        this.setPlayerInstance(player);
        DragonWhistleHandler.DragonInstance instance = this.getDragonInstance(index);
        CompoundTag nbt = this.dragonNBTs.get(index);
        UUID uuid = instance.getUUID();
        if (nbt != null && (type = EntityType.by((CompoundTag)nbt)).isPresent() && (entity = ((EntityType)type.get()).create(world)) instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            dragon.load(nbt);
            dragon.setUUID(UUID.randomUUID());
            dragon.setDragonUUID(uuid);
            dragon.stopSitting();
            dragon.setWanderTarget(Optional.empty());
            this.setDragonToWhistle(dragon, index);
            dragon.clearFire();
            dragon.hurtTime = 0;
            dragon.setHealth(Math.max(1.0f, dragon.getHealth()));
            dragon.removeEffectsCuredBy(EffectCures.PROTECTED_BY_TOTEM);
            this.lastSummons.put(index, dragon.getUUID());
            return dragon;
        }
        return null;
    }

    public DragonWhistleHandler.DragonInstance getDragonInstance(int index) {
        return this.dragonInstances.get(index);
    }

    public void setDragonInstance(int index, DragonWhistleHandler.DragonInstance instance) {
        this.dragonInstances.put(index, instance);
    }

    public void setDragonToWhistle(TameableDragonEntity dragon, int index) {
        Player player;
        dragon.setTame(true, true);
        dragon.setOwnerUUID(this.playerInstance.getGameProfile().getId());
        Optional wanderPos = dragon.getWanderTarget();
        boolean sit = dragon.isOrderedToSit();
        dragon.setWanderTarget(Optional.empty());
        dragon.setOrderedToSit(false);
        CompoundTag nbtData = dragon.serializeNBT((HolderLookup.Provider)dragon.level.registryAccess());
        this.dragonNBTs.put(index, nbtData);
        if (!dragon.level.isClientSide && (player = this.playerInstance) instanceof ServerPlayer) {
            ServerPlayer spPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)spPlayer, (CustomPacketPayload)new DragonNBTSync(index, nbtData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        DragonWhistleHandler.DragonInstance instance = new DragonWhistleHandler.DragonInstance(dragon);
        this.dragonInstances.put(index, instance);
        dragon.setWanderTarget(wanderPos);
        dragon.setOrderedToSit(sit);
        this.lastSummons.put(index, dragon.getUUID());
    }

    public boolean isBoundToWhistle(TameableDragonEntity dragon) {
        if (dragon.getDragonUUID() != null) {
            return this.dragonInstances.values().stream().anyMatch(instance -> instance.getUUID().equals(dragon.getDragonUUID()));
        }
        return false;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("shouldDismount", this.shouldDismount);
        tag.putInt("dragonsHatched", this.dragonsHatched);
        tag.putBoolean("cameraFlight", this.cameraFlight);
        tag.putBoolean("alternateDismount", this.alternateDismount);
        for (DyeColor color : DyeColor.values()) {
            if (this.lastSummons.containsKey(color.getId())) {
                tag.putUUID("last_summon_" + color.getId(), this.lastSummons.get(color.getId()));
            }
            if (this.respawnDelays.containsKey(color.getId())) {
                tag.putInt("respawnDelay_" + color.getId(), this.respawnDelays.get(color.getId()).intValue());
            }
            if (!this.dragonNBTs.containsKey(color.getId())) continue;
            tag.put("dragonNBT_" + color.getId(), (Tag)this.dragonNBTs.get(color.getId()));
        }
        CompoundTag instancesTag = new CompoundTag();
        for (Map.Entry entry : this.dragonInstances.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).toList()) {
            DragonWhistleHandler.DragonInstance instance = (DragonWhistleHandler.DragonInstance)entry.getValue();
            instancesTag.put(((Integer)entry.getKey()).toString(), (Tag)instance.writeNBT());
        }
        tag.put("dragonInstances", (Tag)instancesTag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag base) {
        if (base.contains("shouldDismount")) {
            this.shouldDismount = base.getBoolean("shouldDismount");
        }
        this.dragonsHatched = base.getInt("dragonsHatched");
        this.respawnDelays.clear();
        this.dragonNBTs.clear();
        this.dragonInstances.clear();
        if (base.contains("cameraFlight")) {
            this.cameraFlight = base.getBoolean("cameraFlight");
        }
        if (base.contains("alternateDismount")) {
            this.alternateDismount = base.getBoolean("alternateDismount");
        }
        for (DyeColor color : DyeColor.values()) {
            if (base.contains("last_summon_" + color.getId())) {
                this.lastSummons.put(color.getId(), base.getUUID("last_summon_" + color.getId()));
            }
            if (base.contains("respawnDelay_" + color.getId())) {
                this.respawnDelays.put(color.getId(), base.getInt("respawnDelay_" + color.getId()));
            }
            if (base.contains("dragonNBT_" + color.getId())) {
                this.dragonNBTs.put(color.getId(), base.getCompound("dragonNBT_" + color.getId()));
            }
            if (!base.contains("dragonUUID_" + color.getId())) continue;
            UUID id = base.getUUID("dragonUUID_" + color.getId());
            DragonWhistleHandler.DragonInstance instance = new DragonWhistleHandler.DragonInstance(this.getPlayerInstance() != null ? this.getPlayerInstance().level.dimension().toString() : "minecraft:overworld", UUID.randomUUID(), id);
            this.dragonInstances.put(color.getId(), instance);
        }
        CompoundTag instances = base.getCompound("dragonInstances");
        for (String jsKey : instances.getAllKeys()) {
            int key = Integer.parseInt(jsKey);
            DragonWhistleHandler.DragonInstance instance = new DragonWhistleHandler.DragonInstance();
            instance.readNBT(instances.getCompound(jsKey));
            this.dragonInstances.put(key, instance);
        }
    }

    @Generated
    public void setPlayerInstance(Player playerInstance) {
        this.playerInstance = playerInstance;
    }

    @Generated
    public Player getPlayerInstance() {
        return this.playerInstance;
    }
}

