/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.model;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import dmr.DragonMounts.registry.ModComponents;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class DragonArmorItemModel {

    @EventBusSubscriber(modid="dmr", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register(ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"dragon_armor"), (IGeometryLoader)new DragonArmorLoader());
        }
    }

    public static class ItemModelResolver
    extends ItemOverrides {
        private final Baked owner;
        private final ItemOverrides nested;

        public ItemModelResolver(Baked owner, ItemOverrides nested) {
            this.owner = owner;
            this.nested = nested;
        }

        public BakedModel resolve(BakedModel original, ItemStack stack, ClientLevel level, LivingEntity entity, int pSeed) {
            BakedModel override = this.nested.resolve(original, stack, level, entity, pSeed);
            if (override != original) {
                return override;
            }
            String armor = (String)stack.get(ModComponents.ARMOR_TYPE);
            BakedModel model = (BakedModel)this.owner.models.get((Object)armor);
            if (model != null) {
                return model;
            }
            return original;
        }
    }

    public static class Baked
    implements IDynamicBakedModel {
        private static final Supplier<BakedModel> FALLBACK = Suppliers.memoize(() -> Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(Items.LEATHER_HORSE_ARMOR));
        private final ImmutableMap<String, BakedModel> models;
        private final ItemOverrides overrides;

        public Baked(ImmutableMap<String, BakedModel> models, ItemOverrides overrides) {
            this.models = models;
            this.overrides = new ItemModelResolver(this, overrides);
        }

        public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            Data data = (Data)extraData.get(Data.PROPERTY);
            if (data != null && this.models.containsKey((Object)data.armorId)) {
                return ((BakedModel)this.models.get((Object)data.armorId())).getQuads(state, side, rand, extraData, renderType);
            }
            return FALLBACK.get().getQuads(state, side, rand, extraData, renderType);
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return FALLBACK.get().getParticleIcon();
        }

        public TextureAtlasSprite getParticleIcon(ModelData modelData) {
            Data data = (Data)modelData.get(Data.PROPERTY);
            if (data != null && this.models.containsKey((Object)data.armorId)) {
                return ((BakedModel)this.models.get((Object)data.armorId())).getParticleIcon(modelData);
            }
            return this.getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return this.overrides;
        }

        public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            return FALLBACK.get().applyTransform(transformType, poseStack, applyLeftHandTransform);
        }

        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            return modelData;
        }
    }

    private record Data(String armorId) {
        private static final ModelProperty<Data> PROPERTY = new ModelProperty();
    }

    static class DragonArmorGeometry
    implements IUnbakedGeometry<DragonArmorGeometry> {
        private final ImmutableMap<String, BlockModel> models;

        public DragonArmorGeometry(ImmutableMap<String, BlockModel> models) {
            this.models = models;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            ImmutableMap.Builder baked = ImmutableMap.builder();
            for (Map.Entry entry : this.models.entrySet()) {
                BlockModel unbaked = (BlockModel)entry.getValue();
                unbaked.resolveParents(arg_0 -> ((ModelBaker)baker).getModel(arg_0));
                baked.put((Object)((String)entry.getKey()), (Object)unbaked.bake(baker, unbaked, spriteGetter, modelState, true));
            }
            return new Baked((ImmutableMap<String, BakedModel>)baked.build(), overrides);
        }
    }

    public static class DragonArmorLoader
    implements IGeometryLoader<DragonArmorGeometry> {
        public DragonArmorGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializer) throws JsonParseException {
            ImmutableMap.Builder models = ImmutableMap.builder();
            String dir = "models/item/dragon_armor";
            int length = "models/".length();
            int suffixLength = ".json".length();
            for (Map.Entry entry : Minecraft.getInstance().getResourceManager().listResources(dir, f -> f.getPath().endsWith(".json")).entrySet()) {
                ResourceLocation rl = (ResourceLocation)entry.getKey();
                String path = rl.getPath();
                path = path.substring(length, path.length() - suffixLength);
                String id = String.format("%s", path.substring("item/dragon_armor/".length(), path.length() - "_dragon_armor".length()));
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                    try {
                        models.put((Object)id, (Object)BlockModel.fromStream((Reader)reader));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return new DragonArmorGeometry((ImmutableMap<String, BlockModel>)models.build());
        }
    }
}

