/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.client.gui.DragonAbilityButton;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.DragonStatePacket;
import dmr.DragonMounts.server.container.DragonContainerMenu;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.abilities.types.Ability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class DragonInventoryScreen
extends AbstractContainerScreen<DragonContainerMenu> {
    private static final ResourceLocation INVENTORY_LOCATION = DMR.id("textures/gui/dragon_inventory.png");
    private static final ResourceLocation STATS_LOCATION = DMR.id("textures/gui/dragon_inventory_stats.png");
    private final TameableDragonEntity dragon;
    private float xMouse;
    private float yMouse;
    private static final ResourceLocation TITLE_BOX_SPRITE = ResourceLocation.withDefaultNamespace((String)"advancements/title_box");

    public DragonInventoryScreen(DragonContainerMenu pMenu, Inventory pPlayerInventory, Component component) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, component);
        this.dragon = pMenu.dragon;
        this.imageWidth = 269;
        this.imageHeight = 204;
        this.titleLabelX = 101;
        this.inventoryLabelX = 101;
        this.inventoryLabelY = 112;
    }

    protected void init() {
        super.init();
        int xSize = 269;
        int ySize = 204;
        this.leftPos = (this.width - xSize) / 2;
        this.topPos = (this.height - ySize) / 2;
        this.addRenderableWidget((GuiEventListener)new ModeButton(this.leftPos + 242 - 36, this.topPos + 17, "dmr.inventory.sit", p_214087_1_ -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonStatePacket(this.dragon.getId(), 0), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ModeButton(this.leftPos + 242 - 18, this.topPos + 17, "dmr.inventory.follow", p_214087_1_ -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonStatePacket(this.dragon.getId(), 1), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ModeButton(this.leftPos + 242, this.topPos + 17, "dmr.inventory.wander", p_214087_1_ -> PacketDistributor.sendToServer((CustomPacketPayload)new DragonStatePacket(this.dragon.getId(), 2), (CustomPacketPayload[])new CustomPacketPayload[0])));
        for (int i = 0; i < 6; ++i) {
            boolean hasAbility = this.dragon.getBreed().getAbilities().size() > i;
            Ability ability = hasAbility ? this.dragon.getBreed().getAbilities().get(i) : null;
            DragonAbilityButton btn = new DragonAbilityButton(this.leftPos + 10 + i % 3 * 29, this.topPos + 143 + i / 3 * 29, ability);
            this.addRenderableWidget((GuiEventListener)btn);
        }
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            this.addRenderableWidget((GuiEventListener)new StatButton(this, 66, "dmr.inventory.stats.max_hp", ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/full.png"), 1, ((Float)this.dragon.getEntityData().get(TameableDragonEntity.healthAttribute)).floatValue(), ServerConfig.LOWER_MAX_HEALTH, ServerConfig.UPPER_MAX_HEALTH));
            this.addRenderableWidget((GuiEventListener)new StatButton(this, 81, "dmr.inventory.stats.damage", ResourceLocation.withDefaultNamespace((String)"textures/mob_effect/strength.png"), 2, ((Float)this.dragon.getEntityData().get(TameableDragonEntity.damageAttribute)).floatValue(), ServerConfig.LOWER_DAMAGE, ServerConfig.UPPER_DAMAGE));
            this.addRenderableWidget((GuiEventListener)new StatButton(this, 96, "dmr.inventory.stats.speed", ResourceLocation.withDefaultNamespace((String)"textures/mob_effect/speed.png"), 3, ((Float)this.dragon.getEntityData().get(TameableDragonEntity.speedAttribute)).floatValue(), ServerConfig.LOWER_SPEED, ServerConfig.UPPER_SPEED));
            this.addRenderableWidget((GuiEventListener)new StatButton(this, 111, "dmr.inventory.stats.scale", null, 4, ((Float)this.dragon.getEntityData().get(TameableDragonEntity.maxScaleAttribute)).floatValue(), 0.0, 1.0));
        }
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        this.xMouse = pMouseX;
        this.yMouse = pMouseY;
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(graphics, pMouseX, pMouseY);
        if (!this.dragon.hasChest()) {
            graphics.fill(this.leftPos + 101, this.topPos + 52, this.leftPos + 101 + 162, this.topPos + 52 + 54, FastColor.ARGB32.color((int)200, (int)0x5B5B5B));
        }
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            graphics.blitSprite(TITLE_BOX_SPRITE, this.leftPos + 6, this.topPos + 49 + 10, 89, 70);
        }
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        pGuiGraphics.drawString(this.font, (Component)Component.translatable((String)"dmr.inventory.abilities"), 8, 131, 0xFFFFFF, false);
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            pGuiGraphics.drawString(this.font, (Component)Component.translatable((String)"dmr.inventory.stats"), 8, 53, 0xFFFFFF, false);
        }
        pGuiGraphics.drawString(this.font, (Component)(this.dragon.getInventory().getItem(2).is(Items.ENDER_CHEST) ? Component.translatable((String)"container.enderchest") : Component.translatable((String)"dmr.inventory.chest")), this.inventoryLabelX, 42, 0x404040, false);
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.blit(this.dragon.getBreed().getInventoryTexture(), this.leftPos + 3, this.topPos + 3, 0.0f, 0.0f, 96, 198, 16, 16);
        pGuiGraphics.fill(this.leftPos + 3, this.topPos + 3, this.leftPos + 3 + 96, this.topPos + 3 + 200, FastColor.ARGB32.color((int)100, (int)0x5B5B5B));
        pGuiGraphics.blit(INVENTORY_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, 269, 204, 512, 512);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)pGuiGraphics, (int)(this.leftPos + 7), (int)(this.topPos + 7), (int)(this.leftPos + 7 + 87), (int)(this.topPos + 7 + 42), (int)7, (float)1.0f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)this.dragon);
    }

    public static class ModeButton
    extends ExtendedButton {
        public ModeButton(int xPos, int yPos, String text, Button.OnPress handler) {
            super(xPos, yPos, 18, 18, (Component)Component.literal((String)Component.translatable((String)text).getString(1)), handler);
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)text)));
        }
    }

    class StatButton
    extends ExtendedButton {
        private final String title;
        private final ResourceLocation sprite;
        private final int barNum;
        private final double value;
        private final double actual;
        private final double minValue;
        private final double maxValue;

        public StatButton(DragonInventoryScreen this$0, int y, String title, ResourceLocation sprite, int barNum, double value, double minValue, double maxValue) {
            super(this$0.leftPos + 10, this$0.topPos + y, 80, 12, (Component)Component.empty(), btn -> {});
            this.title = title;
            this.sprite = sprite;
            this.barNum = barNum;
            this.value = value;
            double actual = value * (maxValue - minValue) + minValue;
            this.actual = (double)((int)(actual * 10.0)) / 10.0;
            this.maxValue = (double)((int)(maxValue * 10.0)) / 10.0;
            this.minValue = (double)((int)(minValue * 10.0)) / 10.0;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)(title + ".tooltip"), (Object[])new Object[]{(this.actual > 0.0 ? "\u00a7a+" + this.actual : "\u00a7c" + this.actual) + "\u00a7r", this.minValue, this.maxValue})));
        }

        public boolean isActive() {
            return ServerConfig.ENABLE_RANDOM_STATS;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 100.0f);
            int x = this.getX();
            int y = this.getY();
            int barHeight = this.barNum * 5;
            int textX = this.getX();
            if (this.sprite != null) {
                textX += 8;
                int spriteSize = 6;
                graphics.blit(this.sprite, x + 1, y - 1, 0.0f, 0.0f, spriteSize, spriteSize, spriteSize, spriteSize);
            }
            pose.pushPose();
            pose.scale(0.5f, 0.5f, 0.5f);
            pose.translate((float)textX, (float)y, 0.0f);
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)this.title), textX, y, 0xFFFFFF, false);
            pose.popPose();
            pose.pushPose();
            String valueString = (this.actual > 0.0 ? "\u00a7a+" + this.actual : "\u00a7c" + this.actual) + "\u00a7r / \u00a73" + this.maxValue + "\u00a7r";
            int length = Minecraft.getInstance().font.width(valueString);
            int posX = this.getX() + (this.width - length / 2);
            pose.scale(0.5f, 0.5f, 0.5f);
            pose.translate((float)posX, (float)y, 0.0f);
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)valueString), posX, y, 0xFFFFFF, false);
            pose.popPose();
            graphics.blit(STATS_LOCATION, x, y + 6, 0.0f, 0.0f, 80, 5, 80, 30);
            graphics.blit(STATS_LOCATION, x, y + 6, 0.0f, (float)barHeight, (int)(80.0 * this.value), 5, 80, 30);
            pose.popPose();
        }
    }
}

