/*
 * Decompiled with CFR 0.152.
 */
package compatibility.jei;

import compatibility.jei.DragonArmorInterpreter;
import compatibility.jei.DragonEggInterpreter;
import compatibility.jei.DragonSpawnEggInterpreter;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.registry.DragonArmorRegistry;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.types.armor.DragonArmor;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class DMRJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return DMR.id("jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ModItems.DRAGON_SPAWN_EGG.get(), (ISubtypeInterpreter)new DragonSpawnEggInterpreter());
        registration.registerSubtypeInterpreter(ModItems.DRAGON_EGG_BLOCK_ITEM.get(), (ISubtypeInterpreter)new DragonEggInterpreter());
        registration.registerSubtypeInterpreter(ModItems.DRAGON_ARMOR.get(), (ISubtypeInterpreter)new DragonArmorInterpreter());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        DMRJeiPlugin.addNetheriteArmorRecipe(recipes);
        DMRJeiPlugin.addBlankDragonEggRecipe(recipes);
        registration.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    public static void addNetheriteArmorRecipe(List<RecipeHolder<CraftingRecipe>> recipes) {
        ItemStack result = new ItemStack((ItemLike)ModItems.DRAGON_ARMOR.get());
        ItemStack diamondArmor = new ItemStack((ItemLike)ModItems.DRAGON_ARMOR.get());
        DragonArmor.setArmorType(diamondArmor, DragonArmorRegistry.getDragonArmor("diamond"));
        DragonArmor.setArmorType(result, DragonArmorRegistry.getDragonArmor("netherite"));
        ShapelessRecipe netheriteArmorRecipe = new ShapelessRecipe("dragon", CraftingBookCategory.MISC, result, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{diamondArmor}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})}));
        RecipeHolder netheriteArmorRecipeHolder = new RecipeHolder(DMR.id("netherite_armor_recipe"), (Recipe)netheriteArmorRecipe);
        recipes.add((RecipeHolder<CraftingRecipe>)netheriteArmorRecipeHolder);
    }

    public static void addBlankDragonEggRecipe(List<RecipeHolder<CraftingRecipe>> recipes) {
        ItemStack result = new ItemStack((ItemLike)ModItems.BLANK_EGG_BLOCK_ITEM.get());
        ShapelessRecipe eggRecipe = new ShapelessRecipe("dragon", CraftingBookCategory.MISC, result, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get()})}));
        RecipeHolder eggRecipeHolder = new RecipeHolder(DMR.id("blank_egg_recipe"), (Recipe)eggRecipe);
        recipes.add((RecipeHolder<CraftingRecipe>)eggRecipeHolder);
    }
}

