/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.generic;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderableBoxGroup;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3d;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBox;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBoxGroupShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class CloudRenderHandler {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final String CLOUD_RESOURCE_TEXTURE_PATH = "assets/distanthorizons/textures/clouds.png";
    private static final boolean DEBUG_BORDER_COLORS = false;
    private static final int CLOUD_BOX_WIDTH = 128;
    private static final int CLOUD_BOX_THICKNESS = 32;
    private static final int CLOUD_INSTANCE_RADIUS_COUNT = 5;
    private final IDhApiRenderableBoxGroup[][] boxGroupByOffset = new IDhApiRenderableBoxGroup[11][11];
    private final IDhClientLevel level;
    private final GenericObjectRenderer renderer;
    private float moveSpeedInBlocksPerSecond = 6.0f;
    private boolean disabledWarningLogged = false;

    public CloudRenderHandler(IDhClientLevel level, GenericObjectRenderer renderer) {
        this.level = level;
        this.renderer = renderer;
        boolean[][] cloudLocations = new boolean[1][1];
        try {
            cloudLocations = CloudRenderHandler.getCloudsFromTexture();
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected issue getting cloud texture, error: [" + e.getMessage() + "].", e);
        }
        if (cloudLocations.length != 0 && cloudLocations.length != cloudLocations[0].length) {
            LOGGER.warn("Non-square cloud texture found, some parts of the texture will be clipped off.", new Object[0]);
        }
        int textureWidth = cloudLocations.length;
        ArrayList<DhApiRenderableBox> boxList = new ArrayList<DhApiRenderableBox>(512);
        for (int x = 0; x < textureWidth; ++x) {
            for (int z = 0; z < textureWidth; ++z) {
                int endZ;
                if (!cloudLocations[x][z]) continue;
                int startZ = z;
                int startX = x;
                int endX = x + 1;
                for (endZ = startZ; endZ < textureWidth && cloudLocations[x][endZ]; ++endZ) {
                }
                z = endZ - 1;
                for (int currentX = startX + 1; currentX < textureWidth; ++currentX) {
                    boolean canMergeInXDir = true;
                    for (int adjacentZ = startZ; adjacentZ < endZ; ++adjacentZ) {
                        if (cloudLocations[currentX][adjacentZ]) continue;
                        canMergeInXDir = false;
                        break;
                    }
                    if (!canMergeInXDir) break;
                    for (int currentZ = startZ; currentZ < endZ; ++currentZ) {
                        cloudLocations[currentX][currentZ] = false;
                    }
                    endX = currentX + 1;
                }
                int minXBlockPos = startX * 128;
                int minZBlockPos = startZ * 128;
                int maxXBlockPos = endX * 128;
                int maxZBlockPos = endZ * 128;
                Color color = new Color(255, 255, 255, 255);
                DhApiRenderableBox box = new DhApiRenderableBox(new DhApiVec3d(minXBlockPos, 0.0, minZBlockPos), new DhApiVec3d(maxXBlockPos, 32.0, maxZBlockPos), color, EDhApiBlockMaterial.UNKNOWN);
                boxList.add(box);
            }
        }
        DhApiRenderableBoxGroupShading cloudShading = DhApiRenderableBoxGroupShading.getUnshaded();
        cloudShading.south = 0.9f;
        cloudShading.north = 0.9f;
        cloudShading.west = 0.8f;
        cloudShading.east = 0.8f;
        cloudShading.top = 1.0f;
        cloudShading.bottom = 0.7f;
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                IDhApiRenderableBoxGroup boxGroup = GenericRenderObjectFactory.INSTANCE.createRelativePositionedGroup("DistantHorizons:Clouds", new DhApiVec3d(0.0, 0.0, 0.0), boxList);
                boxGroup.setBlockLight(15);
                boxGroup.setSkyLight(15);
                boxGroup.setSsaoEnabled(false);
                boxGroup.setShading(cloudShading);
                CloudParams cloudParams = new CloudParams(textureWidth, x, z);
                boxGroup.setPreRenderFunc(renderParam -> this.preRender((DhApiRenderParam)renderParam, cloudParams));
                renderer.add(boxGroup);
                this.boxGroupByOffset[x + 5][z + 5] = boxGroup;
            }
        }
    }

    private void preRender(DhApiRenderParam renderParam, CloudParams cloudParams) {
        float newMinPosZ;
        IDhApiRenderableBoxGroup boxGroup = this.boxGroupByOffset[cloudParams.instanceOffsetX + 5][cloudParams.instanceOffsetZ + 5];
        boolean renderClouds = Config.Client.Advanced.Graphics.GenericRendering.enableCloudRendering.get();
        boxGroup.setActive(renderClouds);
        if (!renderClouds) {
            return;
        }
        if (!this.renderer.getInstancedRenderingAvailable()) {
            if (!this.disabledWarningLogged) {
                this.disabledWarningLogged = true;
                LOGGER.warn("Instanced rendering unavailable, cloud rendering disabled.", new Object[0]);
            }
            boxGroup.setActive(false);
            return;
        }
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - cloudParams.lastFrameTime) / 1000.0f;
        cloudParams.lastFrameTime = currentTime;
        float deltaX = this.moveSpeedInBlocksPerSecond * deltaTime;
        cloudParams.deltaOffsetX -= deltaX;
        cloudParams.deltaOffsetX %= (float)cloudParams.widthInBlocks;
        int cameraPosX = (int)CloudRenderHandler.MC_RENDER.getCameraExactPosition().x;
        int cameraPosZ = (int)CloudRenderHandler.MC_RENDER.getCameraExactPosition().z;
        if (cameraPosX < 0) {
            cameraPosX -= cloudParams.widthInBlocks;
        }
        if (cameraPosZ < 0) {
            cameraPosZ -= cloudParams.widthInBlocks;
        }
        int cloudInstanceOffsetCountX = cameraPosX / cloudParams.widthInBlocks;
        int cloudInstanceOffsetCountZ = cameraPosZ / cloudParams.widthInBlocks;
        float instanceOffsetX = cloudInstanceOffsetCountX * cloudParams.widthInBlocks;
        float instanceOffsetZ = cloudInstanceOffsetCountZ * cloudParams.widthInBlocks;
        float newMinPosX = cloudParams.deltaOffsetX + (float)(cloudParams.instanceOffsetX * cloudParams.widthInBlocks) + instanceOffsetX + (float)cloudParams.halfWidthInBlocks;
        float newMinPosY = this.level.getLevelWrapper().getMaxHeight() + 200;
        boolean cullCloud = this.shouldCloudBeCulled(newMinPosX, newMinPosY, newMinPosZ = cloudParams.deltaOffsetZ + (float)(cloudParams.instanceOffsetZ * cloudParams.widthInBlocks) + instanceOffsetZ + (float)cloudParams.halfWidthInBlocks, cloudParams);
        if (cullCloud) {
            boxGroup.setActive(false);
        }
        if (boxGroup.isActive()) {
            Color newCloudColor = this.level.getClientLevelWrapper().getCloudColor(renderParam.partialTicks);
            DhApiRenderableBox firstBox = (DhApiRenderableBox)boxGroup.get(0);
            Color currentBoxColor = firstBox.color;
            if (!newCloudColor.equals(currentBoxColor)) {
                for (DhApiRenderableBox box : boxGroup) {
                    box.color = newCloudColor;
                }
            }
            if (!cloudParams.previousColor.equals(newCloudColor)) {
                cloudParams.previousColor = newCloudColor;
                boxGroup.triggerBoxChange();
            }
        }
        boxGroup.setOriginBlockPos(new DhApiVec3d(newMinPosX, newMinPosY, newMinPosZ));
    }

    private synchronized boolean shouldCloudBeCulled(float minPosX, float minPosY, float minPosZ, CloudParams cloudParams) {
        if (cloudParams.instanceOffsetX >= -1 && cloudParams.instanceOffsetX <= 1 && cloudParams.instanceOffsetZ >= -1 && cloudParams.instanceOffsetZ <= 1) {
            return false;
        }
        Vec3d[] corners = new Vec3d[]{new Vec3d(minPosX, minPosY, minPosZ), new Vec3d(minPosX, minPosY, minPosZ + (float)cloudParams.widthInBlocks), new Vec3d(minPosX + (float)cloudParams.widthInBlocks, minPosY, minPosZ), new Vec3d(minPosX + (float)cloudParams.widthInBlocks, minPosY, minPosZ + (float)cloudParams.widthInBlocks)};
        Vec3d cameraPos = MC_RENDER.getCameraExactPosition();
        Vec3f cameraLookAtVector = MC_RENDER.getLookAtVector();
        cameraLookAtVector.normalize();
        double renderDistance = (double)(Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16) * 1.5;
        boolean allOutsideRenderDistance = true;
        boolean allBehindCamera = true;
        for (Vec3d corner : corners) {
            Vec3d cornerNoHeight = new Vec3d(corner);
            cornerNoHeight.y = 0.0;
            Vec3d cameraPosNoHeight = new Vec3d(cameraPos);
            cameraPosNoHeight.y = 0.0;
            double cornerDistance = cornerNoHeight.getDistance(cameraPosNoHeight);
            if (cornerDistance <= renderDistance) {
                allOutsideRenderDistance = false;
            }
            Vec3f toCorner = new Vec3f((float)(corner.x - cameraPos.x), (float)(corner.y - cameraPos.y), (float)(corner.z - cameraPos.z));
            toCorner.normalize();
            if (!(cameraLookAtVector.dotProduct(toCorner) > 0.0f)) continue;
            allBehindCamera = false;
        }
        return allOutsideRenderDistance || allBehindCamera;
    }

    private static boolean[][] getCloudsFromTexture() throws FileNotFoundException, IOException {
        ClassLoader loader = CloudRenderHandler.class.getClassLoader();
        boolean[][] whitePixels = null;
        try (InputStream imageInputStream = loader.getResourceAsStream(CLOUD_RESOURCE_TEXTURE_PATH);){
            if (imageInputStream == null) {
                throw new FileNotFoundException("Unable to find cloud texture at resource path: [assets/distanthorizons/textures/clouds.png].");
            }
            BufferedImage image = ImageIO.read(imageInputStream);
            int width = image.getWidth();
            int height = image.getHeight();
            whitePixels = new boolean[width][height];
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    Color color = new Color(image.getRGB(x, z));
                    whitePixels[x][z] = color.equals(Color.WHITE);
                }
            }
        }
        return whitePixels;
    }

    private static class CloudParams {
        public final int textureWidth;
        public final int widthInBlocks;
        public final int halfWidthInBlocks;
        public final int instanceOffsetX;
        public final int instanceOffsetZ;
        public float deltaOffsetX = 0.0f;
        public float deltaOffsetZ = 0.0f;
        public long lastFrameTime = System.currentTimeMillis();
        public Color previousColor = Color.WHITE;

        public CloudParams(int textureWidth, int instanceOffsetX, int instanceOffsetZ) {
            this.textureWidth = textureWidth;
            this.widthInBlocks = this.textureWidth * 128;
            this.halfWidthInBlocks = this.widthInBlocks / 2;
            this.instanceOffsetX = instanceOffsetX;
            this.instanceOffsetZ = instanceOffsetZ;
        }
    }
}

