/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.client;

import com.google.common.base.Stopwatch;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.tasks.DataSourceRetrievalResult;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.network.exceptions.RateLimitedException;
import com.seibel.distanthorizons.core.network.exceptions.RequestOutOfRangeException;
import com.seibel.distanthorizons.core.network.exceptions.RequestRejectedException;
import com.seibel.distanthorizons.core.network.exceptions.SectionRequiresSplittingException;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceRequestMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceResponseMessage;
import com.seibel.distanthorizons.core.network.session.SessionClosedException;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ratelimiting.SupplierBasedRateLimiter;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.awt.Color;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public abstract class AbstractFullDataNetworkRequestQueue
implements IDebugRenderable,
AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logNetworkEventToFile).maxCountPerSecond(3).build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final int MAX_RETRY_ATTEMPTS = 3;
    protected static final long SHUTDOWN_TIMEOUT_SECONDS = 5L;
    public final ClientNetworkState networkState;
    protected final DhClientLevel level;
    private final boolean changedOnly;
    private volatile CompletableFuture<Void> closingFuture = null;
    protected final ConcurrentMap<Long, NetRequestTask> waitingTasksBySectionPos = new ConcurrentHashMap<Long, NetRequestTask>();
    private final Semaphore pendingTasksSemaphore = new Semaphore(Short.MAX_VALUE, true);
    private final AtomicInteger finishedRequests = new AtomicInteger();
    private final AtomicInteger failedRequests = new AtomicInteger();
    private final ConfigEntry<Boolean> showDebugWireframeConfig;
    private final SupplierBasedRateLimiter<Void> rateLimiter = new SupplierBasedRateLimiter(this::getRequestRateLimit);

    public AbstractFullDataNetworkRequestQueue(ClientNetworkState networkState, DhClientLevel level, boolean changedOnly, ConfigEntry<Boolean> showDebugWireframeConfig) {
        this.networkState = networkState;
        this.level = level;
        this.changedOnly = changedOnly;
        this.showDebugWireframeConfig = showDebugWireframeConfig;
        DebugRenderer.register(this, this.showDebugWireframeConfig);
    }

    protected abstract int getRequestRateLimit();

    protected abstract boolean sectionInAllowedGenerationRadius(long var1, DhBlockPos2D var3);

    protected abstract boolean onBeforeRequest(long var1, CompletableFuture<DataSourceRetrievalResult> var3);

    protected abstract String getQueueName();

    public CompletableFuture<DataSourceRetrievalResult> submitRequest(long sectionPos, @Nullable Long clientTimestamp) {
        NetRequestTask requestEntry = this.waitingTasksBySectionPos.compute(sectionPos, (pos, existingNetTask) -> {
            if (existingNetTask != null) {
                return existingNetTask;
            }
            NetRequestTask newRequestEntry = new NetRequestTask((long)pos, clientTimestamp);
            newRequestEntry.future.whenComplete((requestResult, throwable) -> {
                this.waitingTasksBySectionPos.remove(pos);
                if (throwable != null) {
                    if (!(throwable instanceof CancellationException)) {
                        this.failedRequests.incrementAndGet();
                    }
                    return;
                }
                switch (requestResult.state) {
                    case SUCCESS: {
                        this.finishedRequests.incrementAndGet();
                        break;
                    }
                }
            });
            return newRequestEntry;
        });
        return requestEntry.future;
    }

    public synchronized boolean tick(DhBlockPos2D targetPos) {
        if (DhApiWorldProxy.INSTANCE.worldLoaded() && DhApiWorldProxy.INSTANCE.getReadOnly()) {
            return false;
        }
        if (this.closingFuture != null || !this.networkState.isReady()) {
            return false;
        }
        while (this.getInProgressTaskCount() < this.getWaitingTaskCount() && this.getInProgressTaskCount() < this.getRequestRateLimit() && this.pendingTasksSemaphore.tryAcquire()) {
            if (!this.rateLimiter.tryAcquire()) {
                this.pendingTasksSemaphore.release();
                break;
            }
            this.sendNextRequest(targetPos);
        }
        return true;
    }

    private void sendNextRequest(DhBlockPos2D targetPos) {
        Map.Entry nearestMapEntry = this.waitingTasksBySectionPos.entrySet().stream().filter(task -> ((NetRequestTask)task.getValue()).networkDataSourceFuture == null).min(Comparator.comparingInt(mapEntry -> DhSectionPos.getChebyshevSignedBlockDistance((long)((Long)mapEntry.getKey()), targetPos))).orElse(null);
        if (nearestMapEntry == null) {
            this.pendingTasksSemaphore.release();
            return;
        }
        long requestPos = (Long)nearestMapEntry.getKey();
        NetRequestTask requestTask = (NetRequestTask)nearestMapEntry.getValue();
        if (!this.sectionInAllowedGenerationRadius(requestPos, targetPos)) {
            requestTask.future.cancel(false);
            this.pendingTasksSemaphore.release();
            return;
        }
        if (!this.onBeforeRequest(requestPos, requestTask.future)) {
            this.pendingTasksSemaphore.release();
            return;
        }
        Long offsetEntryTimestamp = requestTask.updateTimestamp != null ? Long.valueOf(requestTask.updateTimestamp + this.networkState.getServerTimeOffset()) : null;
        CompletableFuture<FullDataSourceResponseMessage> dataSourceNetworkFuture = this.networkState.getSession().sendRequest(new FullDataSourceRequestMessage(this.level.getLevelWrapper(), requestPos, offsetEntryTimestamp), FullDataSourceResponseMessage.class);
        requestTask.networkDataSourceFuture = dataSourceNetworkFuture;
        PriorityTaskPicker.Executor networkCompressionExecutor = ThreadPoolUtil.getNetworkCompressionExecutor();
        if (networkCompressionExecutor == null) {
            return;
        }
        dataSourceNetworkFuture.handleAsync((response, throwable) -> {
            this.handleNetResponse(requestTask, (FullDataSourceResponseMessage)response, (Throwable)throwable);
            return null;
        }, (Executor)networkCompressionExecutor);
    }

    private void handleNetResponse(NetRequestTask requestTask, FullDataSourceResponseMessage response, Throwable throwable) {
        this.pendingTasksSemaphore.release();
        try {
            if (throwable != null) {
                throw throwable;
            }
            if (response.payload == null) {
                LodUtil.assertTrue(this.changedOnly, "Received empty data source response for not changes-only request");
                return;
            }
            try (FullDataSourceV2DTO dataSourceDto = this.networkState.fullDataPayloadReceiver.decodeDataSource(response.payload);){
                dataSourceDto.applyToChildren = DhSectionPos.getDetailLevel(dataSourceDto.pos) > 6;
                dataSourceDto.applyToParent = DhSectionPos.getDetailLevel(dataSourceDto.pos) < 18;
                this.level.updateBeaconBeamsForSectionPos(dataSourceDto.pos, response.payload.beaconBeams);
                FullDataSourceV2 fullDataSource = dataSourceDto.createDataSource(this.level.getLevelWrapper(), null);
                requestTask.future.complete(DataSourceRetrievalResult.CreateSuccess(dataSourceDto.pos, fullDataSource));
            }
        }
        catch (SectionRequiresSplittingException ignored) {
            requestTask.future.complete(DataSourceRetrievalResult.CreateSplit());
        }
        catch (SessionClosedException | CancellationException ignored) {
            requestTask.future.cancel(false);
        }
        catch (RequestRejectedException e) {
            LOGGER.info("Request rejected by the server, message: [" + e.getMessage() + "].", new Object[0]);
            requestTask.future.completeExceptionally(e);
        }
        catch (RateLimitedException e) {
            LOGGER.info("Rate limited by server, re-queueing task [" + DhSectionPos.toString(requestTask.pos) + "], message: [" + e.getMessage() + "].", new Object[0]);
            this.rateLimiter.acquireAll();
            requestTask.networkDataSourceFuture = null;
        }
        catch (RequestOutOfRangeException e) {
            LOGGER.debug("Out of range, re-queueing task [" + DhSectionPos.toString(requestTask.pos) + "], message: [" + e.getMessage() + "].", new Object[0]);
            requestTask.networkDataSourceFuture = null;
        }
        catch (Throwable e) {
            --requestTask.retryAttempts;
            LOGGER.error("Unexpected error: [" + e.getMessage() + "] while fetching full data source, attempts left: [" + requestTask.retryAttempts + "] / [" + 3 + "]", e);
            if (requestTask.retryAttempts > 0) {
                requestTask.networkDataSourceFuture = null;
            }
            requestTask.future.completeExceptionally(e);
        }
    }

    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        Iterator farestTaskIterator = this.waitingTasksBySectionPos.entrySet().stream().sorted(Comparator.comparingInt(entry -> {
            Long pos = (Long)entry.getKey();
            DhBlockPos2D targetPos = this.level.getTargetPosForGeneration();
            return DhSectionPos.getChebyshevSignedBlockDistance((long)pos, targetPos);
        }).reversed()).iterator();
        while (farestTaskIterator.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)farestTaskIterator.next();
            long pos = (Long)mapEntry.getKey();
            NetRequestTask entry2 = (NetRequestTask)mapEntry.getValue();
            if (!removeIf.accept(pos)) continue;
            if (entry2.networkDataSourceFuture != null) {
                entry2.networkDataSourceFuture.cancel(false);
            }
            entry2.future.cancel(false);
        }
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        messageList.add(this.getQueueName() + " [" + this.level.getClientLevelWrapper().getDhIdentifier() + "]");
        messageList.add("Requests: " + this.finishedRequests + " / " + (this.getWaitingTaskCount() + this.finishedRequests.get()) + " (failed: " + this.failedRequests + ", rate limit: " + this.getRequestRateLimit() + ")");
    }

    public int getWaitingTaskCount() {
        return this.waitingTasksBySectionPos.size();
    }

    public int getInProgressTaskCount() {
        return Short.MAX_VALUE - this.pendingTasksSemaphore.availablePermits();
    }

    public CompletableFuture<Void> startClosingAsync(boolean alsoInterruptRunning) {
        this.closingFuture = CompletableFuture.runAsync(() -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            do {
                for (NetRequestTask entry : this.waitingTasksBySectionPos.values()) {
                    entry.future.cancel(alsoInterruptRunning);
                    if (entry.networkDataSourceFuture == null || !entry.networkDataSourceFuture.cancel(alsoInterruptRunning)) continue;
                    this.pendingTasksSemaphore.release();
                }
            } while (!this.pendingTasksSemaphore.tryAcquire(Short.MAX_VALUE) && stopwatch.elapsed(TimeUnit.SECONDS) < 5L);
            if (stopwatch.elapsed(TimeUnit.SECONDS) >= 5L) {
                LOGGER.warn("The request queue [" + this.getQueueName() + "] for level [" + this.level.getLevelWrapper() + "] did not shutdown in [" + 5L + "] seconds. Some unfinished tasks might be left hanging.", new Object[0]);
            }
        });
        return this.closingFuture;
    }

    @Override
    public void close() {
        DebugRenderer.unregister(this, this.showDebugWireframeConfig);
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        if (MC_CLIENT.getWrappedClientLevel() != this.level.getClientLevelWrapper()) {
            return;
        }
        DhBlockPos2D targetPos = this.level.getTargetPosForGeneration();
        for (Map.Entry mapEntry : this.waitingTasksBySectionPos.entrySet()) {
            boolean taskInAllowedGenRadius;
            long pos = (Long)mapEntry.getKey();
            NetRequestTask task = (NetRequestTask)mapEntry.getValue();
            Color color = task.networkDataSourceFuture != null ? Color.RED : ((taskInAllowedGenRadius = this.sectionInAllowedGenerationRadius(pos, targetPos)) ? Color.GRAY : Color.DARK_GRAY);
            renderer.renderBox(new DebugRenderer.Box(pos, -32.0f, 64.0f, 0.05f, color));
        }
    }

    protected static class NetRequestTask {
        public final long pos;
        public final CompletableFuture<DataSourceRetrievalResult> future = new CompletableFuture();
        @Nullable
        public final Long updateTimestamp;
        @CheckForNull
        public CompletableFuture<FullDataSourceResponseMessage> networkDataSourceFuture;
        public int retryAttempts = 3;

        public NetRequestTask(long pos, @Nullable Long updateTimestamp) {
            this.pos = pos;
            this.updateTimestamp = updateTimestamp;
        }
    }
}

