/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;

public class RenderUtil {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);

    public static Mat4f createLodProjectionMatrix(Mat4f mcProjMat, float partialTicks) {
        float nearClipDist = RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks);
        if (RenderUtil.getHeightBasedNearClipOverride() == -1.0f) {
            nearClipDist = Math.min(nearClipDist, 7.5f);
        }
        float farClipDist = RenderUtil.getFarClipPlaneDistanceInBlocks();
        Mat4f lodProj = mcProjMat.copy();
        lodProj.setClipPlanes(nearClipDist, farClipDist);
        return lodProj;
    }

    public static Mat4f createLodModelViewMatrix(Mat4f mcModelViewMat) {
        return mcModelViewMat.copy();
    }

    public static float getNearClipPlaneDistanceInBlocks(float partialTicks) {
        return RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks, 0.2f);
    }

    @Deprecated
    public static float getAutoOverdrawPrevention() {
        float overdraw = Config.Client.Advanced.Graphics.Culling.overdrawPrevention.get().floatValue();
        if (overdraw <= 0.0f) {
            int chunkRenderDistance = MC_RENDER.getRenderDistance();
            overdraw = chunkRenderDistance <= 2 ? 0.2f : (chunkRenderDistance <= 4 ? 0.3f : (chunkRenderDistance <= 6 ? 0.6f : (chunkRenderDistance <= 10 ? 0.8f : 0.9f)));
        }
        return overdraw;
    }

    public static float getNearClipPlaneInBlocksForFading(float partialTicks) {
        float overdraw = RenderUtil.getAutoOverdrawPrevention();
        return RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks, overdraw);
    }

    private static float getNearClipPlaneDistanceInBlocks(float partialTicks, float overdrawPreventionPercent) {
        float nearClipPlane;
        int chunkRenderDistance = MC_RENDER.getRenderDistance();
        int vanillaBlockRenderedDistance = chunkRenderDistance * 16;
        if (Config.Client.Advanced.Debugging.lodOnlyMode.get().booleanValue()) {
            nearClipPlane = 0.1f;
        } else {
            nearClipPlane = vanillaBlockRenderedDistance;
            if ((nearClipPlane *= overdrawPreventionPercent) < 0.1f) {
                nearClipPlane = 0.1f;
            }
        }
        float heightOverride = RenderUtil.getHeightBasedNearClipOverride();
        if (heightOverride != -1.0f) {
            nearClipPlane = heightOverride;
        }
        double fov = 70.0;
        double aspectRatio = (double)MC_RENDER.getTargetFramebufferViewportWidth() / (double)MC_RENDER.getTargetFramebufferViewportHeight();
        return (float)((double)nearClipPlane / Math.sqrt(1.0 + MathUtil.pow2(Math.tan(fov / 180.0 * Math.PI / 2.0)) * (MathUtil.pow2(aspectRatio) + 1.0)));
    }

    public static int getFarClipPlaneDistanceInBlocks() {
        int lodChunkDist = Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get();
        int lodBlockDist = lodChunkDist * 16;
        return (lodBlockDist + 512) * 2;
    }

    public static float getHeightBasedNearClipOverride() {
        int levelMaxHeight;
        int playerHeight;
        IClientLevelWrapper level = MC.getWrappedClientLevel();
        if (level != null && (playerHeight = MC.getPlayerBlockPos().getY()) > (levelMaxHeight = level.getMaxHeight()) + 1000) {
            return playerHeight - (levelMaxHeight + 1000);
        }
        return -1.0f;
    }
}

