/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import org.lwjgl.opengl.GL32;

public class DhFadeShader
extends AbstractShaderRenderer {
    public static DhFadeShader INSTANCE = new DhFadeShader();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public int frameBuffer = -1;
    private Mat4f inverseDhMvmProjMatrix;
    public int uDhInvMvmProj = -1;
    public int uDhDepthTexture = -1;
    public int uMcColorTexture = -1;
    public int uDhColorTexture = -1;
    public int uStartFadeBlockDistance = -1;
    public int uEndFadeBlockDistance = -1;

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/fade/dhFade.frag", "fragColor", new String[]{"vPosition"});
        this.uDhInvMvmProj = this.shader.tryGetUniformLocation("uDhInvMvmProj");
        this.uDhDepthTexture = this.shader.tryGetUniformLocation("uDhDepthTexture");
        this.uMcColorTexture = this.shader.tryGetUniformLocation("uMcColorTexture");
        this.uDhColorTexture = this.shader.tryGetUniformLocation("uDhColorTexture");
        this.uStartFadeBlockDistance = this.shader.tryGetUniformLocation("uStartFadeBlockDistance");
        this.uEndFadeBlockDistance = this.shader.tryGetUniformLocation("uEndFadeBlockDistance");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        this.shader.setUniform(this.uDhInvMvmProj, this.inverseDhMvmProjMatrix);
        float dhFarClipDistance = RenderUtil.getFarClipPlaneDistanceInBlocks();
        float fadeStartDistance = dhFarClipDistance * 0.5f;
        float fadeEndDistance = dhFarClipDistance * 0.9f;
        this.shader.setUniform(this.uStartFadeBlockDistance, fadeStartDistance);
        this.shader.setUniform(this.uEndFadeBlockDistance, fadeEndDistance);
    }

    public void setProjectionMatrix(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        Mat4f dhProjectionMatrix = RenderUtil.createLodProjectionMatrix(mcProjectionMatrix, partialTicks);
        Mat4f dhModelViewMatrix = RenderUtil.createLodModelViewMatrix(mcModelViewMatrix);
        Mat4f inverseDhModelViewProjectionMatrix = new Mat4f(dhProjectionMatrix);
        inverseDhModelViewProjectionMatrix.multiply(dhModelViewMatrix);
        inverseDhModelViewProjectionMatrix.invert();
        this.inverseDhMvmProjMatrix = inverseDhModelViewProjectionMatrix;
    }

    @Override
    protected void onRender() {
        int depthTextureId = LodRenderer.INSTANCE.getActiveDepthTextureId();
        int colorTextureId = LodRenderer.INSTANCE.getActiveColorTextureId();
        if (depthTextureId == -1 || colorTextureId == -1) {
            return;
        }
        GLMC.glBindFramebuffer(36160, this.frameBuffer);
        GLMC.disableScissorTest();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(depthTextureId);
        GL32.glUniform1i((int)this.uDhDepthTexture, (int)0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(MC_RENDER.getColorTextureId());
        GL32.glUniform1i((int)this.uMcColorTexture, (int)1);
        GLMC.glActiveTexture(33986);
        GLMC.glBindTexture(colorTextureId);
        GL32.glUniform1i((int)this.uDhColorTexture, (int)2);
        ScreenQuad.INSTANCE.render();
    }
}

