/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.renderer.shaders.SSAOApplyShader;
import com.seibel.distanthorizons.core.render.renderer.shaders.SSAOShader;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL43C;

public class SSAORenderer {
    public static SSAORenderer INSTANCE = new SSAORenderer();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private boolean init = false;
    private int width = -1;
    private int height = -1;
    private int ssaoFramebuffer = -1;
    private int ssaoTexture = -1;

    private SSAORenderer() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        SSAOShader.INSTANCE.init();
        SSAOApplyShader.INSTANCE.init();
    }

    private void createFramebuffer(int width, int height) {
        if (this.ssaoFramebuffer != -1) {
            GL32.glDeleteFramebuffers((int)this.ssaoFramebuffer);
            this.ssaoFramebuffer = -1;
        }
        if (this.ssaoTexture != -1) {
            GLMC.glDeleteTextures(this.ssaoTexture);
            this.ssaoTexture = -1;
        }
        this.ssaoFramebuffer = GL32.glGenFramebuffers();
        GLMC.glBindFramebuffer(36160, this.ssaoFramebuffer);
        this.ssaoTexture = GLMC.glGenTextures();
        GLMC.glBindTexture(this.ssaoTexture);
        GL32.glTexImage2D((int)3553, (int)0, (int)33325, (int)width, (int)height, (int)0, (int)6403, (int)5131, (ByteBuffer)null);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL43C.glTexParameteri((int)3553, (int)33084, (int)0);
        GL43C.glTexParameteri((int)3553, (int)33085, (int)0);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.ssaoTexture, (int)0);
    }

    public void render(Mat4f projectionMatrix, float partialTicks) {
        GLState state = new GLState();
        this.init();
        int width = MC_RENDER.getTargetFramebufferViewportWidth();
        int height = MC_RENDER.getTargetFramebufferViewportHeight();
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.createFramebuffer(width, height);
        }
        SSAOShader.INSTANCE.frameBuffer = this.ssaoFramebuffer;
        SSAOShader.INSTANCE.setProjectionMatrix(projectionMatrix);
        SSAOShader.INSTANCE.render(partialTicks);
        SSAOApplyShader.INSTANCE.ssaoTexture = this.ssaoTexture;
        SSAOApplyShader.INSTANCE.render(partialTicks);
        state.restore();
    }

    public void free() {
        SSAOShader.INSTANCE.free();
        SSAOApplyShader.INSTANCE.free();
    }
}

