/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodBufferContainer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.render.renderer.generic.BeaconRenderHandler;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.WillNotClose;
import org.jetbrains.annotations.Nullable;

public class LodRenderSection
implements IDebugRenderable,
AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final long pos;
    private final IDhClientLevel level;
    private final IClientLevelWrapper levelWrapper;
    @WillNotClose
    private final FullDataSourceProviderV2 fullDataSourceProvider;
    private final LodQuadTree quadTree;
    private final AtomicInteger uploadTaskCountRef;
    private final List<BeaconBeamDTO> activeBeaconList = new ArrayList<BeaconBeamDTO>();
    @Nullable
    public final BeaconRenderHandler beaconRenderHandler;
    @Nullable
    public final BeaconBeamRepo beaconBeamRepo;
    private boolean renderingEnabled = false;
    public LodBufferContainer bufferContainer;
    private CompletableFuture<Void> getAndBuildRenderDataFuture = null;
    private Runnable getAndBuildRenderDataRunnable = null;
    private CompletableFuture<LodBufferContainer> bufferUploadFuture = null;

    @Nullable
    public CompletableFuture<Void> getRenderDataBuildFuture() {
        return this.getAndBuildRenderDataFuture;
    }

    public LodRenderSection(long pos, LodQuadTree quadTree, IDhClientLevel level, FullDataSourceProviderV2 fullDataSourceProvider, AtomicInteger uploadTaskCountRef) {
        this.pos = pos;
        this.quadTree = quadTree;
        this.level = level;
        this.levelWrapper = level.getClientLevelWrapper();
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.uploadTaskCountRef = uploadTaskCountRef;
        this.beaconRenderHandler = this.quadTree.beaconRenderHandler;
        this.beaconBeamRepo = this.level.getBeaconBeamRepo();
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
    }

    public synchronized boolean uploadRenderDataToGpuAsync() {
        if (!GLProxy.hasInstance()) {
            return false;
        }
        if (this.getAndBuildRenderDataFuture != null) {
            return false;
        }
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getRenderLoadingExecutor();
        if (executor == null || executor.isTerminated()) {
            return false;
        }
        if (this.uploadTaskCountRef.getAndIncrement() > executor.getPoolSize()) {
            this.uploadTaskCountRef.decrementAndGet();
            return false;
        }
        try {
            CompletableFuture future = new CompletableFuture();
            this.getAndBuildRenderDataFuture = future;
            future.handle((voidObj, throwable) -> {
                this.uploadTaskCountRef.decrementAndGet();
                return null;
            });
            this.getAndBuildRenderDataRunnable = () -> {
                this.getAndRefreshRenderingBeacons();
                this.getAndUploadRenderDataToGpuAsync().thenRun(() -> {
                    future.complete(null);
                    this.getAndBuildRenderDataFuture = null;
                    this.getAndBuildRenderDataRunnable = null;
                });
            };
            executor.execute(this.getAndBuildRenderDataRunnable);
            return true;
        }
        catch (RejectedExecutionException ignore) {
            this.getAndBuildRenderDataFuture.complete(null);
            this.getAndBuildRenderDataFuture = null;
            this.getAndBuildRenderDataRunnable = null;
            return false;
        }
    }

    private CompletableFuture<Void> getAndUploadRenderDataToGpuAsync() {
        return this.getRenderSourceForPosAsync(this.pos, null).thenCompose(thisRenderSource -> {
            try {
                if (thisRenderSource == null) {
                    return CompletableFuture.completedFuture(null);
                }
                boolean enableTransparency = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
                LodQuadBuilder lodQuadBuilder = new LodQuadBuilder(enableTransparency, this.level.getClientLevelWrapper());
                CompletableFuture[] adjacentLoadFutures = new CompletableFuture[]{this.getRenderSourceForPosAsync(this.pos, EDhDirection.NORTH), this.getRenderSourceForPosAsync(this.pos, EDhDirection.SOUTH), this.getRenderSourceForPosAsync(this.pos, EDhDirection.EAST), this.getRenderSourceForPosAsync(this.pos, EDhDirection.WEST)};
                return CompletableFuture.allOf(adjacentLoadFutures).thenRun(() -> {
                    try (ColumnRenderSource northRenderSource = (ColumnRenderSource)adjacentLoadFutures[0].get();
                         ColumnRenderSource southRenderSource = (ColumnRenderSource)adjacentLoadFutures[1].get();
                         ColumnRenderSource eastRenderSource = (ColumnRenderSource)adjacentLoadFutures[2].get();
                         ColumnRenderSource westRenderSource = (ColumnRenderSource)adjacentLoadFutures[3].get();){
                        ColumnRenderSource[] adjacentRenderSections = new ColumnRenderSource[EDhDirection.CARDINAL_COMPASS.length];
                        adjacentRenderSections[EDhDirection.NORTH.compassIndex] = northRenderSource;
                        adjacentRenderSections[EDhDirection.SOUTH.compassIndex] = southRenderSource;
                        adjacentRenderSections[EDhDirection.EAST.compassIndex] = eastRenderSource;
                        adjacentRenderSections[EDhDirection.WEST.compassIndex] = westRenderSource;
                        boolean[] adjIsSameDetailLevel = new boolean[EDhDirection.CARDINAL_COMPASS.length];
                        adjIsSameDetailLevel[EDhDirection.NORTH.compassIndex] = this.isAdjacentPosSameDetailLevel(EDhDirection.NORTH);
                        adjIsSameDetailLevel[EDhDirection.SOUTH.compassIndex] = this.isAdjacentPosSameDetailLevel(EDhDirection.SOUTH);
                        adjIsSameDetailLevel[EDhDirection.EAST.compassIndex] = this.isAdjacentPosSameDetailLevel(EDhDirection.EAST);
                        adjIsSameDetailLevel[EDhDirection.WEST.compassIndex] = this.isAdjacentPosSameDetailLevel(EDhDirection.WEST);
                        ColumnRenderBufferBuilder.makeLodRenderData(lodQuadBuilder, thisRenderSource, this.level, adjacentRenderSections, adjIsSameDetailLevel);
                        this.uploadToGpuAsync(lodQuadBuilder);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error while loading LodRenderSection [" + DhSectionPos.toString(this.pos) + "] adjacent data, Error: [" + e.getMessage() + "].", e);
                    }
                    finally {
                        thisRenderSource.close();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error while loading LodRenderSection [" + DhSectionPos.toString(this.pos) + "], Error: [" + e.getMessage() + "].", e);
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    private CompletableFuture<ColumnRenderSource> getRenderSourceForPosAsync(long pos, @Nullable EDhDirection direction) {
        if (direction != null) {
            pos = DhSectionPos.getAdjacentPos(pos, direction);
        }
        long finalPos = pos;
        try {
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getRenderLoadingExecutor();
            if (executor == null || executor.isTerminated()) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<ColumnRenderSource> loadFuture = new CompletableFuture<ColumnRenderSource>();
            executor.execute(() -> {
                try (FullDataSourceV2 fullDataSource = direction == null ? this.fullDataSourceProvider.get(finalPos) : this.fullDataSourceProvider.getAdjForDirection(finalPos, direction.opposite());){
                    ColumnRenderSource columnRenderSource = FullDataToRenderDataTransformer.transformFullDataToRenderSource(fullDataSource, this.levelWrapper);
                    loadFuture.complete(columnRenderSource);
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected issue creating render data for pos: [" + DhSectionPos.toString(finalPos) + "], error: [" + e.getMessage() + "].", e);
                }
            });
            return loadFuture;
        }
        catch (RejectedExecutionException ignore) {
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected issue getting and creating render data for pos: [" + DhSectionPos.toString(pos) + "], error: [" + e.getMessage() + "].", e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private boolean isAdjacentPosSameDetailLevel(EDhDirection direction) {
        long adjPos = DhSectionPos.getAdjacentPos(this.pos, direction);
        byte detailLevel = this.quadTree.calculateExpectedDetailLevel(new DhBlockPos2D(MC.getPlayerBlockPos()), adjPos);
        return (detailLevel = (byte)(detailLevel + 6)) == DhSectionPos.getDetailLevel(this.pos);
    }

    private void uploadToGpuAsync(LodQuadBuilder lodQuadBuilder) {
        if (this.bufferUploadFuture != null) {
            this.bufferUploadFuture.cancel(true);
        }
        this.bufferUploadFuture = ColumnRenderBufferBuilder.uploadBuffersAsync(this.level, this.pos, lodQuadBuilder);
        this.bufferUploadFuture.thenAccept(buffer -> {
            LodBufferContainer previousContainer = this.bufferContainer;
            this.bufferContainer = buffer.buffersUploaded ? buffer : null;
            this.getAndBuildRenderDataFuture = null;
            if (previousContainer != null) {
                previousContainer.close();
            }
        });
    }

    public boolean canRender() {
        return this.bufferContainer != null;
    }

    public boolean getRenderingEnabled() {
        return this.renderingEnabled;
    }

    public void setRenderingEnabled(boolean enabled) {
        this.renderingEnabled = enabled;
    }

    public void onRenderingEnabled() {
        this.startRenderingBeacons();
    }

    public void onRenderingDisabled() {
        this.stopRenderingBeacons();
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.CYAN.darker()), 0.2, 32.0f));
        }
    }

    public boolean gpuUploadInProgress() {
        return this.getAndBuildRenderDataFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndRefreshRenderingBeacons() {
        if (this.beaconBeamRepo == null || this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> list = this.activeBeaconList;
        synchronized (list) {
            List<BeaconBeamDTO> activeBeacons = this.beaconBeamRepo.getAllBeamsForPos(this.pos);
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.stopRenderingBeaconAtPos(beam.blockPos);
            }
            this.activeBeaconList.clear();
            this.activeBeaconList.addAll(activeBeacons);
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.startRenderingBeacon(beam);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRenderingBeacons() {
        if (this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> list = this.activeBeaconList;
        synchronized (list) {
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.stopRenderingBeaconAtPos(beam.blockPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRenderingBeacons() {
        if (this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> list = this.activeBeaconList;
        synchronized (list) {
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.startRenderingBeacon(beam);
            }
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        Color color = Color.red;
        if (this.renderingEnabled) {
            color = Color.green;
        } else if (this.getAndBuildRenderDataFuture != null) {
            color = Color.yellow;
        } else if (this.canRender()) {
            color = Color.cyan;
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 400.0f, 8.0f, (Object)Objects.hashCode(this), 0.1f, color));
    }

    public String toString() {
        return "pos=[" + DhSectionPos.toString(this.pos) + "] enabled=[" + this.renderingEnabled + "] uploading=[" + this.gpuUploadInProgress() + "] ";
    }

    @Override
    public void close() {
        CompletableFuture<LodBufferContainer> uploadFuture;
        Runnable runnable;
        PriorityTaskPicker.Executor renderLoaderExecutor;
        CompletableFuture<Void> buildFuture;
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.RED.darker()), 0.5, 32.0f));
        }
        this.stopRenderingBeacons();
        if (this.bufferContainer != null) {
            this.bufferContainer.close();
        }
        if ((buildFuture = this.getAndBuildRenderDataFuture) != null && (renderLoaderExecutor = ThreadPoolUtil.getRenderLoadingExecutor()) != null && !renderLoaderExecutor.isTerminated() && (runnable = this.getAndBuildRenderDataRunnable) != null) {
            renderLoaderExecutor.remove(runnable);
        }
        if ((uploadFuture = this.bufferUploadFuture) != null) {
            uploadFuture.cancel(true);
        }
    }
}

