/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodBufferContainer;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.generation.tasks.DataSourceRetrievalResult;
import com.seibel.distanthorizons.core.generation.tasks.ERetrievalResultState;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.render.renderer.generic.BeaconRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.WorldGenUtil;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadTree;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillNotClose;
import org.jetbrains.annotations.Nullable;

public class LodQuadTree
extends QuadTree<LodRenderSection>
implements IDebugRenderable,
IConfigListener,
AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final ThreadPoolExecutor FULL_DATA_RETRIEVAL_QUEUE_THREAD = ThreadUtil.makeSingleThreadPool("LodQuadTree Data Retrieval Queue");
    public final int blockRenderDistanceDiameter;
    @WillNotClose
    private final FullDataSourceProviderV2 fullDataSourceProvider;
    private final ConcurrentLinkedQueue<Long> sectionsToReload = new ConcurrentLinkedQueue();
    private final IDhClientLevel level;
    private final ReentrantLock treeLock = new ReentrantLock();
    private ArrayList<LodRenderSection> debugRenderSections = new ArrayList();
    private ArrayList<LodRenderSection> altDebugRenderSections = new ArrayList();
    private final ReentrantLock debugRenderSectionLock = new ReentrantLock();
    private final AtomicInteger uploadTaskCountRef = new AtomicInteger(0);
    private final AtomicBoolean requeueAllRetrievalTasksRef = new AtomicBoolean(false);
    private final AtomicBoolean queueThreadRunningRef = new AtomicBoolean(false);
    @Nullable
    public final BeaconRenderHandler beaconRenderHandler;
    private byte maxLeafRenderDetailLevel;
    private byte minRootRenderDetailLevel;
    private double detailDropOffDistanceUnit;
    private double detailDropOffLogBase;
    private final Set<Long> missingGenerationPosSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Long> queuedGenerationPosSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ArrayList<Long> sortedMissingPosList = new ArrayList();

    public LodQuadTree(IDhClientLevel level, int viewDiameterInBlocks, int initialPlayerBlockX, int initialPlayerBlockZ, FullDataSourceProviderV2 fullDataSourceProvider) {
        super(viewDiameterInBlocks, new DhBlockPos2D(initialPlayerBlockX, initialPlayerBlockZ), (byte)6);
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus);
        this.level = level;
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.blockRenderDistanceDiameter = viewDiameterInBlocks;
        GenericObjectRenderer genericObjectRenderer = this.level.getGenericRenderer();
        this.beaconRenderHandler = genericObjectRenderer != null ? new BeaconRenderHandler(genericObjectRenderer) : null;
        Config.Common.WorldGenerator.enableDistantGeneration.addListener(this);
    }

    public void tick(DhBlockPos2D playerPos) {
        if (this.level == null) {
            return;
        }
        if (this.treeLock.tryLock()) {
            this.updateDetailLevelVariables();
            try {
                this.setCenterBlockPos(playerPos, renderSection -> {
                    if (renderSection != null) {
                        this.fullDataSourceProvider.removeRetrievalRequestIf(genPos -> DhSectionPos.contains(renderSection.pos, genPos));
                        this.missingGenerationPosSet.remove(renderSection.pos);
                        this.queuedGenerationPosSet.remove(renderSection.pos);
                        renderSection.close();
                    }
                });
                this.updateAllRenderSections(playerPos);
            }
            catch (Exception e) {
                LOGGER.error("Quad Tree tick exception for level: [" + this.level.getLevelWrapper().getDhIdentifier() + "], error: [" + e.getMessage() + "].", e);
            }
            finally {
                this.treeLock.unlock();
            }
        }
    }

    private void updateAllRenderSections(DhBlockPos2D playerPos) {
        if (Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus.get().booleanValue()) {
            try {
                this.debugRenderSectionLock.lock();
                this.debugRenderSections.clear();
                ArrayList<LodRenderSection> temp = this.debugRenderSections;
                this.debugRenderSections = this.altDebugRenderSections;
                this.altDebugRenderSections = temp;
            }
            finally {
                this.debugRenderSectionLock.unlock();
            }
        }
        HashSet<LodRenderSection> nodesNeedingLoading = new HashSet<LodRenderSection>();
        LongIterator rootPosIterator = this.rootNodePosIterator();
        while (rootPosIterator.hasNext()) {
            QuadNode<LodRenderSection> rootNode;
            long rootPos = rootPosIterator.nextLong();
            if (this.getNode(rootPos) == null) {
                this.setValue(rootPos, new LodRenderSection(rootPos, this, this.level, this.fullDataSourceProvider, this.uploadTaskCountRef));
            }
            LodUtil.assertTrue((rootNode = this.getNode(rootPos)) != null, "All root nodes should have been created by this point.");
            this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, rootNode, rootNode.sectionPos, false, nodesNeedingLoading);
        }
        if (this.requeueAllRetrievalTasksRef.get() && !this.queueThreadRunningRef.get()) {
            this.queueThreadRunningRef.set(true);
            this.requeueAllRetrievalTasksRef.set(false);
            FULL_DATA_RETRIEVAL_QUEUE_THREAD.execute(() -> {
                try {
                    this.checkAllNodesForRetrievalRequests();
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error getting new queued retrieval tasks, error: [" + e.getMessage() + "].", e);
                }
                finally {
                    this.queueThreadRunningRef.set(false);
                }
            });
        }
        if (this.missingGenerationPosSet.size() != 0 && this.fullDataSourceProvider.canQueueRetrievalNow() && !this.queueThreadRunningRef.get()) {
            this.queueThreadRunningRef.set(true);
            FULL_DATA_RETRIEVAL_QUEUE_THREAD.execute(() -> {
                try {
                    this.startQueuedRetrievalTasks(playerPos);
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error starting queued retrieval tasks, error: [" + e.getMessage() + "].", e);
                }
                finally {
                    this.queueThreadRunningRef.set(false);
                }
            });
        }
        this.reloadQueuedSections();
        this.loadQueuedSections(playerPos, nodesNeedingLoading);
    }

    private boolean recursivelyUpdateRenderSectionNode(DhBlockPos2D playerPos, QuadNode<LodRenderSection> rootNode, QuadNode<LodRenderSection> quadNode, long sectionPos, boolean parentSectionIsRendering, HashSet<LodRenderSection> nodesNeedingLoading) {
        if (quadNode == null && this.isSectionPosInBounds(sectionPos)) {
            rootNode.setValue(sectionPos, new LodRenderSection(sectionPos, this, this.level, this.fullDataSourceProvider, this.uploadTaskCountRef));
            quadNode = rootNode.getNode(sectionPos);
        }
        if (quadNode == null) {
            return false;
        }
        LodRenderSection renderSection = (LodRenderSection)quadNode.value;
        if (renderSection == null) {
            renderSection = new LodRenderSection(sectionPos, this, this.level, this.fullDataSourceProvider, this.uploadTaskCountRef);
            quadNode.setValue(sectionPos, renderSection);
        }
        byte expectedDetailLevel = this.calculateExpectedDetailLevel(playerPos, sectionPos);
        expectedDetailLevel = (byte)Math.min(expectedDetailLevel, this.minRootRenderDetailLevel);
        expectedDetailLevel = (byte)(expectedDetailLevel + 6);
        if (DhSectionPos.getDetailLevel(sectionPos) > expectedDetailLevel) {
            QuadNode<LodRenderSection> childNode;
            int i;
            boolean thisPosIsRendering = renderSection.getRenderingEnabled();
            boolean allChildrenSectionsAreLoaded = true;
            for (i = 0; i < 4; ++i) {
                childNode = quadNode.getChildByIndex(i);
                boolean childSectionLoaded = this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, childNode, DhSectionPos.getChildByIndex(sectionPos, i), thisPosIsRendering || parentSectionIsRendering, nodesNeedingLoading);
                allChildrenSectionsAreLoaded = childSectionLoaded && allChildrenSectionsAreLoaded;
            }
            if (!allChildrenSectionsAreLoaded) {
                return thisPosIsRendering;
            }
            if (renderSection.getRenderingEnabled()) {
                renderSection.onRenderingDisabled();
                long parentPos = renderSection.pos;
                while (DhSectionPos.getDetailLevel(parentPos) <= this.treeRootDetailLevel) {
                    LodRenderSection parentRenderSection;
                    QuadNode parentNode = this.getNode(parentPos);
                    if (parentNode != null && (parentRenderSection = (LodRenderSection)parentNode.value) != null) {
                        parentRenderSection.setRenderingEnabled(false);
                        LodBufferContainer buffer = parentRenderSection.bufferContainer;
                        if (buffer != null) {
                            buffer.close();
                            parentRenderSection.bufferContainer = null;
                        }
                    }
                    parentPos = DhSectionPos.getParentPos(parentPos);
                }
                if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionToggling.get().booleanValue()) {
                    DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(renderSection.pos, 128.0f, 156.0f, 0.09f, Color.WHITE), 0.2, 32.0f));
                }
            }
            for (i = 0; i < 4; ++i) {
                childNode = quadNode.getChildByIndex(i);
                this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, childNode, DhSectionPos.getChildByIndex(sectionPos, i), parentSectionIsRendering, nodesNeedingLoading);
            }
            renderSection.setRenderingEnabled(false);
            return true;
        }
        if (DhSectionPos.getDetailLevel(sectionPos) == expectedDetailLevel || DhSectionPos.getDetailLevel(sectionPos) == expectedDetailLevel - 1) {
            if (!renderSection.gpuUploadInProgress() && renderSection.bufferContainer == null) {
                nodesNeedingLoading.add(renderSection);
            }
            if (Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus.get().booleanValue()) {
                this.debugRenderSections.add(renderSection);
            }
            if (!parentSectionIsRendering && renderSection.canRender() && !renderSection.getRenderingEnabled()) {
                renderSection.setRenderingEnabled(true);
                quadNode.deleteAllChildren(childRenderSection -> {
                    if (childRenderSection != null) {
                        if (childRenderSection.getRenderingEnabled() && Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionToggling.get().booleanValue()) {
                            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(childRenderSection.pos, 128.0f, 156.0f, 0.09f, Color.MAGENTA), 0.2, 32.0f));
                        }
                        childRenderSection.setRenderingEnabled(false);
                        childRenderSection.onRenderingDisabled();
                        childRenderSection.close();
                    }
                });
                renderSection.onRenderingEnabled();
                this.tryQueuePosForRetrieval(renderSection.pos);
            }
            return renderSection.canRender();
        }
        throw new IllegalStateException("LodQuadTree shouldn't be updating renderSections below the expected detail level: [" + expectedDetailLevel + "].");
    }

    private void reloadQueuedSections() {
        Long pos;
        HashSet<Long> positionsToRequeue = new HashSet<Long>();
        while ((pos = this.sectionsToReload.poll()) != null) {
            if (positionsToRequeue.contains(pos)) continue;
            try {
                LodRenderSection renderSection = (LodRenderSection)this.getValue(pos);
                if (renderSection == null || !renderSection.canRender() || !renderSection.gpuUploadInProgress() && renderSection.uploadRenderDataToGpuAsync()) continue;
                positionsToRequeue.add(pos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        this.sectionsToReload.addAll(positionsToRequeue);
    }

    private void loadQueuedSections(DhBlockPos2D playerPos, HashSet<LodRenderSection> nodesNeedingLoading) {
        ArrayList<LodRenderSection> loadSectionList = new ArrayList<LodRenderSection>(nodesNeedingLoading);
        loadSectionList.sort((a, b) -> {
            int aDist = DhSectionPos.getManhattanBlockDistance(a.pos, playerPos);
            int bDist = DhSectionPos.getManhattanBlockDistance(b.pos, playerPos);
            return Integer.compare(aDist, bDist);
        });
        for (int i = 0; i < loadSectionList.size(); ++i) {
            LodRenderSection renderSection = loadSectionList.get(i);
            if (renderSection.gpuUploadInProgress() || renderSection.bufferContainer != null) continue;
            renderSection.uploadRenderDataToGpuAsync();
        }
    }

    private void startQueuedRetrievalTasks(DhBlockPos2D playerPos) {
        this.sortedMissingPosList.clear();
        this.sortedMissingPosList.addAll(this.missingGenerationPosSet);
        this.sortedMissingPosList.sort((posA, posB) -> {
            int aDist = DhSectionPos.getManhattanBlockDistance(posA, playerPos);
            int bDist = DhSectionPos.getManhattanBlockDistance(posB, playerPos);
            return Integer.compare(aDist, bDist);
        });
        for (int i = 0; i < this.sortedMissingPosList.size() && this.fullDataSourceProvider.canQueueRetrievalNow(); ++i) {
            boolean positionQueued;
            long missingPos = this.sortedMissingPosList.get(i);
            boolean posInRange = WorldGenUtil.isPosInWorldGenRange(missingPos, Config.Common.WorldGenerator.generationCenterChunkX.get(), Config.Common.WorldGenerator.generationCenterChunkZ.get(), Config.Common.WorldGenerator.generationMaxChunkRadius.get());
            if (!posInRange) continue;
            CompletableFuture<DataSourceRetrievalResult> genFuture = this.fullDataSourceProvider.queuePositionForRetrieval(missingPos);
            boolean bl = positionQueued = genFuture != null && !genFuture.isCompletedExceptionally();
            if (!positionQueued) continue;
            this.queuedGenerationPosSet.add(missingPos);
            this.missingGenerationPosSet.remove(missingPos);
            genFuture.exceptionally(throwable -> {
                this.queuedGenerationPosSet.remove(missingPos);
                this.missingGenerationPosSet.add(missingPos);
                return null;
            });
            genFuture.thenAccept(result -> {
                this.queuedGenerationPosSet.remove(missingPos);
                if (result.state == ERetrievalResultState.FAIL) {
                    this.missingGenerationPosSet.add(missingPos);
                } else if (result.state == ERetrievalResultState.REQUIRES_SPLITTING) {
                    DhSectionPos.forEachChild(missingPos, childPos -> this.tryQueuePosForRetrieval(childPos));
                }
            });
        }
        int totalWorldGenChunkCount = 0;
        int totalWorldGenTaskCount = 0;
        for (int i = 0; i < this.sortedMissingPosList.size(); ++i) {
            long missingPos = this.sortedMissingPosList.get(i);
            int sectionWidthInChunks = DhSectionPos.getChunkWidth(missingPos);
            totalWorldGenChunkCount += sectionWidthInChunks * sectionWidthInChunks;
            ++totalWorldGenTaskCount;
        }
        this.fullDataSourceProvider.setEstimatedRemainingRetrievalChunkCount(totalWorldGenChunkCount);
        this.fullDataSourceProvider.setTotalRetrievalPositionCount(totalWorldGenTaskCount);
    }

    @Override
    public void onConfigValueSet() {
        boolean generatorEnabled = Config.Common.WorldGenerator.enableDistantGeneration.get();
        if (generatorEnabled) {
            this.requeueAllRetrievalTasksRef.set(true);
        } else {
            this.missingGenerationPosSet.clear();
            this.queuedGenerationPosSet.clear();
            this.requeueAllRetrievalTasksRef.set(false);
        }
    }

    private void checkAllNodesForRetrievalRequests() {
        Iterator nodeIterator = this.nodeIterator();
        while (nodeIterator.hasNext()) {
            LodRenderSection renderSection;
            QuadNode node = nodeIterator.next();
            if (node == null || (renderSection = (LodRenderSection)node.value) == null || !renderSection.getRenderingEnabled()) continue;
            this.tryQueuePosForRetrieval(renderSection.pos);
        }
    }

    private void tryQueuePosForRetrieval(long pos) {
        LongArrayList missingPosList = this.fullDataSourceProvider.getPositionsToRetrieve(pos);
        if (missingPosList == null) {
            return;
        }
        for (int i = 0; i < missingPosList.size(); ++i) {
            long missingPos = missingPosList.getLong(i);
            if (this.queuedGenerationPosSet.contains(missingPos)) continue;
            this.missingGenerationPosSet.add(missingPos);
        }
    }

    public byte calculateExpectedDetailLevel(DhBlockPos2D playerPos, long sectionPos) {
        return this.getDetailLevelFromDistance(playerPos.dist(DhSectionPos.getCenterBlockPosX(sectionPos), DhSectionPos.getCenterBlockPosZ(sectionPos)));
    }

    private byte getDetailLevelFromDistance(double distance) {
        double maxDetailDistance = this.getDrawDistanceFromDetail(126);
        if (distance > maxDetailDistance) {
            return 126;
        }
        int detailLevel = (int)(Math.log(distance / this.detailDropOffDistanceUnit) / this.detailDropOffLogBase);
        return (byte)MathUtil.clamp(this.maxLeafRenderDetailLevel, detailLevel, 126);
    }

    private double getDrawDistanceFromDetail(int detail) {
        if (detail <= this.maxLeafRenderDetailLevel) {
            return 0.0;
        }
        if (detail >= 127) {
            return this.blockRenderDistanceDiameter * 2;
        }
        double base = Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().quadraticBase;
        return Math.pow(base, detail) * this.detailDropOffDistanceUnit;
    }

    private void updateDetailLevelVariables() {
        this.detailDropOffDistanceUnit = Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().distanceUnitInBlocks * 16;
        this.detailDropOffLogBase = Math.log(Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().quadraticBase);
        this.maxLeafRenderDetailLevel = Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution.get().detailLevel;
        byte minSectionDetailLevel = this.getDetailLevelFromDistance(this.blockRenderDistanceDiameter);
        minSectionDetailLevel = (byte)(minSectionDetailLevel - 1);
        minSectionDetailLevel = (byte)Math.min(minSectionDetailLevel, this.treeRootDetailLevel);
        this.minRootRenderDetailLevel = (byte)Math.max(minSectionDetailLevel, this.maxLeafRenderDetailLevel);
    }

    public void clearRenderDataCache() {
        try {
            this.treeLock.lock();
            LOGGER.info("Disposing render data...", new Object[0]);
            Iterator nodeIterator = this.nodeIterator();
            while (nodeIterator.hasNext()) {
                QuadNode quadNode = nodeIterator.next();
                if (quadNode.value == null) continue;
                ((LodRenderSection)quadNode.value).close();
                quadNode.value = null;
            }
            LOGGER.info("Render data cleared, please wait a moment for everything to reload...", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error when clearing LodQuadTree render cache: " + e.getMessage(), e);
        }
        finally {
            this.treeLock.unlock();
        }
    }

    public void reloadPos(long pos) {
        this.sectionsToReload.add(pos);
        for (EDhDirection direction : EDhDirection.CARDINAL_COMPASS) {
            long adjacentPos = DhSectionPos.getAdjacentPos(pos, direction);
            this.sectionsToReload.add(adjacentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        try {
            this.debugRenderSectionLock.lock();
            for (int i = 0; i < this.debugRenderSections.size(); ++i) {
                LodRenderSection renderSection = this.debugRenderSections.get(i);
                Color color = Color.BLACK;
                if (renderSection.gpuUploadInProgress()) {
                    color = Color.ORANGE;
                } else if (renderSection.bufferContainer == null) {
                    color = Color.PINK;
                } else if (renderSection.bufferContainer.hasNonNullVbos()) {
                    color = renderSection.bufferContainer.vboBufferCount() != 0 ? Color.GREEN : Color.RED;
                }
                debugRenderer.renderBox(new DebugRenderer.Box(renderSection.pos, 400.0f, 400.0f, (Object)Objects.hashCode(this), 0.05f, color));
            }
        }
        finally {
            this.debugRenderSectionLock.unlock();
        }
    }

    @Override
    public void close() {
        LOGGER.info("Shutting down LodQuadTree...", new Object[0]);
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus);
        Config.Common.WorldGenerator.enableDistantGeneration.removeListener(this);
        ThreadPoolExecutor mainCleanupExecutor = ThreadPoolUtil.getCleanupExecutor();
        mainCleanupExecutor.execute(() -> {
            this.treeLock.lock();
            try {
                Iterator nodeIterator = this.nodeIterator();
                while (nodeIterator.hasNext()) {
                    QuadNode quadNode = nodeIterator.next();
                    LodRenderSection renderSection = (LodRenderSection)quadNode.value;
                    if (renderSection == null) continue;
                    renderSection.close();
                    quadNode.value = null;
                }
            }
            finally {
                this.treeLock.unlock();
            }
        });
        LOGGER.info("Finished shutting down LodQuadTree", new Object[0]);
    }
}

