/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pooling;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import java.lang.ref.PhantomReference;

public abstract class AbstractPhantomArrayList
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private final PhantomArrayListPool phantomArrayListPool;
    private final PhantomReference<AbstractPhantomArrayList> phantomReference;
    protected final PhantomArrayListCheckout pooledArraysCheckout;

    public AbstractPhantomArrayList(PhantomArrayListPool phantomArrayListPool, int byteArrayCount, int shortArrayCount, int longArrayCount) {
        if (byteArrayCount < 0 || shortArrayCount < 0 || longArrayCount < 0) {
            throw new IllegalArgumentException("Can't get a negative number of pooled arrays.");
        }
        this.phantomArrayListPool = phantomArrayListPool;
        this.phantomReference = new PhantomReference<AbstractPhantomArrayList>(this, this.phantomArrayListPool.phantomRefQueue);
        this.pooledArraysCheckout = this.phantomArrayListPool.checkoutArrays(byteArrayCount, shortArrayCount, longArrayCount);
        this.phantomArrayListPool.phantomRefToCheckout.put(this.phantomReference, this.pooledArraysCheckout);
    }

    @Override
    public void close() {
        this.phantomArrayListPool.returnParentPhantomRef(this.phantomReference);
    }
}

