/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile.V1;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV1;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV1DTO;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV1Repo;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceProviderV1<TDhLevel extends IDhLevel>
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    protected final ReentrantLock closeLock = new ReentrantLock();
    protected volatile boolean isShutdown = false;
    protected final TDhLevel level;
    protected final File saveDir;
    public final FullDataSourceV1Repo repo;

    public FullDataSourceProviderV1(TDhLevel level, File saveDir) throws SQLException, IOException {
        this.level = level;
        this.saveDir = saveDir;
        if (!this.saveDir.exists() && !this.saveDir.mkdirs()) {
            LOGGER.warn("Unable to create full data folder, file saving may fail.", new Object[0]);
        }
        this.repo = new FullDataSourceV1Repo("jdbc:dh_sqlite", new File(this.saveDir.getPath() + File.separator + "DistantHorizons.sqlite"));
    }

    protected FullDataSourceV1 createDataSourceFromDto(FullDataSourceV1DTO dto) throws InterruptedException, IOException, DataCorruptedException {
        FullDataSourceV1 dataSource = FullDataSourceV1.createEmpty(dto.pos);
        try (DhDataInputStream inputStream = dto.getInputStream();){
            dataSource.populateFromStream(dto, inputStream, (IDhLevel)this.level);
        }
        return dataSource;
    }

    public CompletableFuture<FullDataSourceV1> getAsync(long pos) {
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
        if (executor == null || executor.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return CompletableFuture.supplyAsync(() -> this.get(pos), executor);
        }
        catch (RejectedExecutionException ignore) {
            return CompletableFuture.completedFuture(null);
        }
    }

    @Nullable
    public FullDataSourceV1 get(Long pos) {
        FullDataSourceV1 dataSource = null;
        try (FullDataSourceV1DTO dto2 = (FullDataSourceV1DTO)this.repo.getByKey(pos);){
            if (dto2 != null) {
                dataSource = this.createDataSourceFromDto(dto2);
            }
        }
        catch (InterruptedException dto2) {
        }
        catch (DataCorruptedException e) {
            LOGGER.warn("Corrupted data found at pos [" + DhSectionPos.toString(pos) + "]. Data at position will be deleted so it can be re-generated and to prevent future issues. Error: " + e.getMessage(), new Object[0]);
            this.repo.deleteWithKey(pos);
        }
        catch (IOException e) {
            LOGGER.warn("File read Error for pos [" + DhSectionPos.toString(pos) + "], error: " + e.getMessage(), e);
        }
        return dataSource;
    }

    public long getDataSourceMigrationCount() {
        return this.repo.getMigrationCount();
    }

    public ArrayList<FullDataSourceV1> getDataSourcesToMigrate(int limit) {
        ArrayList<FullDataSourceV1> dataSourceList = new ArrayList<FullDataSourceV1>();
        LongArrayList migrationPosList = this.repo.getPositionsToMigrate(limit);
        for (int i = 0; i < migrationPosList.size(); ++i) {
            Long pos = migrationPosList.getLong(i);
            FullDataSourceV1 dataSource = this.get(pos);
            if (dataSource == null) continue;
            dataSourceList.add(dataSource);
        }
        return dataSourceList;
    }

    public void markMigrationFailed(long pos) {
        this.repo.markMigrationFailed(pos);
    }

    @Override
    public void close() {
        try {
            this.closeLock.lock();
            this.isShutdown = true;
            LOGGER.info("Closing [" + this.getClass().getSimpleName() + "] for level: [" + this.level + "].", new Object[0]);
            this.repo.close();
        }
        finally {
            this.closeLock.unlock();
        }
    }
}

