/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataUpdatePropagatorV2;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.DataSourceRetrievalResult;
import com.seibel.distanthorizons.core.generation.tasks.ERetrievalResultState;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;

public class GeneratedFullDataSourceProvider
extends FullDataSourceProviderV2
implements IDebugRenderable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static final int MAX_WORLD_GEN_REQUESTS_PER_THREAD = 20;
    public static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("Generated Provider");
    private final AtomicReference<IFullDataSourceRetrievalQueue> worldGenQueueRef = new AtomicReference<Object>(null);
    private final ArrayList<IOnWorldGenCompleteListener> onWorldGenTaskCompleteListeners = new ArrayList();
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSaveAsync, 10000);

    public GeneratedFullDataSourceProvider(IDhLevel level, ISaveStructure saveStructure) throws SQLException, IOException {
        this(level, saveStructure, null);
    }

    public GeneratedFullDataSourceProvider(IDhLevel level, ISaveStructure saveStructure, @Nullable File saveDirOverride) throws SQLException, IOException {
        super(level, saveStructure, saveDirOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        ArrayList<IOnWorldGenCompleteListener> arrayList = this.onWorldGenTaskCompleteListeners;
        synchronized (arrayList) {
            this.onWorldGenTaskCompleteListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        ArrayList<IOnWorldGenCompleteListener> arrayList = this.onWorldGenTaskCompleteListeners;
        synchronized (arrayList) {
            this.onWorldGenTaskCompleteListeners.remove(listener);
        }
    }

    private void onWorldGenTaskComplete(DataSourceRetrievalResult genTaskResult, Throwable exception) {
        try {
            if (exception != null) {
                return;
            }
            if (genTaskResult.state == ERetrievalResultState.FAIL) {
                LodUtil.assertTrue(genTaskResult.dataSource == null, "Errored retrieval object should not have a datasource.");
                if (!ExceptionUtil.isInterruptOrReject(exception)) {
                    LOGGER.error("Uncaught Gen Task Exception at [" + genTaskResult.pos + "], error: [" + exception.getMessage() + "].", exception);
                }
            } else if (genTaskResult.state == ERetrievalResultState.SUCCESS) {
                LodUtil.assertTrue(genTaskResult.dataSource != null, "Successful retrieval object should have a datasource.");
                this.dataUpdater.updateDataSource(genTaskResult.dataSource);
                this.fireOnGenPosSuccessListeners(genTaskResult.pos);
                genTaskResult.dataSource.close();
            } else if (genTaskResult.state == ERetrievalResultState.REQUIRES_SPLITTING) {
                LodUtil.assertTrue(genTaskResult.dataSource == null, "Split retrieval object should not have a datasource.");
            } else {
                LOGGER.warn("Unexpected gen Task state at: [" + DhSectionPos.toString(genTaskResult.pos) + "], state: [" + (Object)((Object)genTaskResult.state) + "], datasource: NULL, exception: NULL.", new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected issue during onWorldGenTaskComplete, error: [" + e.getMessage() + "].", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOnGenPosSuccessListeners(long pos) {
        ArrayList<IOnWorldGenCompleteListener> arrayList = this.onWorldGenTaskCompleteListeners;
        synchronized (arrayList) {
            for (IOnWorldGenCompleteListener listener : this.onWorldGenTaskCompleteListeners) {
                listener.onWorldGenTaskComplete(pos);
            }
        }
    }

    public byte lowestDataDetailLevel() {
        IFullDataSourceRetrievalQueue fullDataSourceRetrievalQueue = this.worldGenQueueRef.get();
        if (fullDataSourceRetrievalQueue == null) {
            return 6;
        }
        return (byte)(6 + fullDataSourceRetrievalQueue.lowestDataDetail());
    }

    public void setWorldGenerationQueue(IFullDataSourceRetrievalQueue newWorldGenQueue) {
        boolean oldQueueExists = this.worldGenQueueRef.compareAndSet(null, newWorldGenQueue);
        LodUtil.assertTrue(oldQueueExists, "previous world gen queue is still here!");
        LOGGER.info("Set world gen queue for level [" + this.levelId + "].", new Object[0]);
    }

    @Override
    public boolean canRetrieveMissingDataSources() {
        return true;
    }

    @Override
    public void setEstimatedRemainingRetrievalChunkCount(int newCount) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            worldGenQueue.setRetrievalEstimatedRemainingChunkCount(newCount);
        }
    }

    @Override
    public boolean canQueueRetrievalNow() {
        return this.canQueueRetrievalNow(false);
    }

    public boolean canQueueRetrievalNow(boolean pruneWaitingTasksAboveLimit) {
        if (!super.canQueueRetrievalNow()) {
            return false;
        }
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return false;
        }
        PriorityTaskPicker.Executor renderLoadExecutor = ThreadPoolUtil.getRenderLoadingExecutor();
        if (renderLoadExecutor == null || renderLoadExecutor.getQueueSize() >= FullDataUpdatePropagatorV2.getMaxPropagateTaskCount() / 2) {
            return false;
        }
        PriorityTaskPicker.Executor fileHandlerExecutor = ThreadPoolUtil.getFileHandlerExecutor();
        if (fileHandlerExecutor == null || fileHandlerExecutor.getQueueSize() >= FullDataUpdatePropagatorV2.getMaxPropagateTaskCount() / 2) {
            return false;
        }
        int maxQueuedChunkCount = 20 * Config.Common.MultiThreading.numberOfThreads.get();
        if (SharedApi.INSTANCE.getQueuedChunkUpdateCount() >= maxQueuedChunkCount) {
            return false;
        }
        int maxWorldGenQueueCount = 20 * Config.Common.MultiThreading.numberOfThreads.get();
        if (this.delayedFullDataSourceSaveCache.getUnsavedCount() >= maxWorldGenQueueCount) {
            this.delayedFullDataSourceSaveCache.flush();
            return false;
        }
        int availableTaskSlots = maxWorldGenQueueCount - worldGenQueue.getWaitingTaskCount();
        if (availableTaskSlots == 0) {
            return false;
        }
        if (availableTaskSlots < 0) {
            if (pruneWaitingTasksAboveLimit) {
                AtomicInteger tasksToCancel = new AtomicInteger(availableTaskSlots * -1);
                worldGenQueue.removeRetrievalRequestIf(taskPos -> tasksToCancel.getAndDecrement() > 0);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public CompletableFuture<DataSourceRetrievalResult> queuePositionForRetrieval(Long genPos) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return null;
        }
        CompletableFuture<DataSourceRetrievalResult> worldGenFuture = worldGenQueue.submitRetrievalTask(genPos, (byte)(DhSectionPos.getDetailLevel(genPos) - 6));
        worldGenFuture.whenComplete(this::onWorldGenTaskComplete);
        return worldGenFuture;
    }

    @Override
    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            worldGenQueue.removeRetrievalRequestIf(removeIf);
        }
    }

    @Override
    public void clearRetrievalQueue() {
        this.worldGenQueueRef.set(null);
    }

    public boolean generationStepsAreFullyGenerated(ByteArrayList columnGenerationSteps) {
        return IntStream.range(0, columnGenerationSteps.size()).noneMatch(intValue -> {
            byte value = columnGenerationSteps.getByte(intValue);
            return value == EDhApiWorldGenerationStep.EMPTY.value || value == EDhApiWorldGenerationStep.DOWN_SAMPLED.value;
        });
    }

    @Override
    public LongArrayList getPositionsToRetrieve(long pos) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return null;
        }
        if (this.repo.existsWithKey(pos)) {
            try (PhantomArrayListCheckout checkout = ARRAY_LIST_POOL.checkoutArrays(1, 0, 0);){
                ByteArrayList columnGenStepArray = checkout.getByteArray(0, 4096);
                this.repo.getColumnGenerationStepForPos(pos, columnGenStepArray);
                if (columnGenStepArray.size() != 0) {
                    boolean positionFullyGenerated = true;
                    for (int i = 0; i < columnGenStepArray.size(); ++i) {
                        if (columnGenStepArray.getByte(i) != EDhApiWorldGenerationStep.EMPTY.value && columnGenStepArray.getByte(i) != EDhApiWorldGenerationStep.DOWN_SAMPLED.value) continue;
                        positionFullyGenerated = false;
                        break;
                    }
                    if (positionFullyGenerated) {
                        LongArrayList longArrayList = new LongArrayList();
                        return longArrayList;
                    }
                }
            }
        }
        LongArrayList generationList = new LongArrayList();
        byte lowestGeneratorDetailLevel = (byte)Math.min(worldGenQueue.lowestDataDetail() + 6, DhSectionPos.getDetailLevel(pos));
        DhSectionPos.forEachChildAtDetailLevel(pos, lowestGeneratorDetailLevel, genPos -> {
            if (!this.repo.existsWithKey(genPos)) {
                generationList.add(genPos);
            } else {
                EDhApiWorldGenerationStep currentMinWorldGenStep;
                block15: {
                    currentMinWorldGenStep = EDhApiWorldGenerationStep.LIGHT;
                    try (PhantomArrayListCheckout checkout = ARRAY_LIST_POOL.checkoutArrays(1, 0, 0);){
                        ByteArrayList columnGenerationSteps = checkout.getByteArray(0, 4096);
                        this.repo.getColumnGenerationStepForPos(genPos, columnGenerationSteps);
                        if (columnGenerationSteps.isEmpty()) {
                            return;
                        }
                        for (int x = 0; x < 64; ++x) {
                            for (int z = 0; z < 64; ++z) {
                                EDhApiWorldGenerationStep newWorldGenStep;
                                int index = FullDataSourceV2.relativePosToIndex(x, z);
                                byte genStepValue = columnGenerationSteps.getByte(index);
                                if (genStepValue < currentMinWorldGenStep.value && (newWorldGenStep = EDhApiWorldGenerationStep.fromValue(genStepValue)) != null && newWorldGenStep.value < currentMinWorldGenStep.value) {
                                    currentMinWorldGenStep = newWorldGenStep;
                                }
                                if (currentMinWorldGenStep != EDhApiWorldGenerationStep.EMPTY) {
                                    if (currentMinWorldGenStep != EDhApiWorldGenerationStep.DOWN_SAMPLED) continue;
                                }
                                break block15;
                            }
                        }
                    }
                }
                if (currentMinWorldGenStep != EDhApiWorldGenerationStep.EMPTY && currentMinWorldGenStep != EDhApiWorldGenerationStep.DOWN_SAMPLED) {
                    return;
                }
                generationList.add(genPos);
            }
        });
        return generationList;
    }

    @Override
    public void close() {
        super.close();
        this.delayedFullDataSourceSaveCache.close();
    }

    private CompletableFuture<Void> onDataSourceSaveAsync(FullDataSourceV2 fullDataSource) {
        int skyLight = this.level.getLevelWrapper().hasSkyLight() ? 15 : 0;
        DhLightingEngine.INSTANCE.bakeDataSourceSkyLight(fullDataSource, skyLight);
        return this.updateDataSourceAsync(fullDataSource);
    }

    public static interface IOnWorldGenCompleteListener {
        public boolean shouldDoWorldGen();

        public DhBlockPos2D getTargetPosForGeneration();

        public void onWorldGenTaskComplete(long var1);
    }
}

