/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.api.enums.config.EDhApiBlocksToAvoid;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class FullDataToRenderDataTransformer {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final LongOpenHashSet BROKEN_POS_SET = new LongOpenHashSet();
    private static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("Data Transformer");
    private static HashSet<IBlockStateWrapper> snowLayerBlockStates = null;

    @Nullable
    public static ColumnRenderSource transformFullDataToRenderSource(@Nullable FullDataSourceV2 fullDataSource, @Nullable IClientLevelWrapper levelWrapper) {
        if (fullDataSource == null) {
            return null;
        }
        if (levelWrapper == null) {
            return null;
        }
        try {
            return FullDataToRenderDataTransformer.transformCompleteFullDataToColumnData(levelWrapper, fullDataSource);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static ColumnRenderSource transformCompleteFullDataToColumnData(IClientLevelWrapper levelWrapper, FullDataSourceV2 fullDataSource) throws InterruptedException {
        long pos = fullDataSource.getPos();
        byte dataDetail = fullDataSource.getDataDetailLevel();
        int vertSize = Config.Client.Advanced.Graphics.Quality.verticalQuality.get().calculateMaxVerticalData(fullDataSource.getDataDetailLevel());
        ColumnRenderSource columnSource = ColumnRenderSource.createEmpty(pos, vertSize, levelWrapper.getMinHeight());
        if (fullDataSource.isEmpty) {
            return columnSource;
        }
        columnSource.markNotEmpty();
        int baseX = DhSectionPos.getMinCornerBlockX(pos);
        int baseZ = DhSectionPos.getMinCornerBlockZ(pos);
        for (int x = 0; x < 64; ++x) {
            for (int z = 0; z < 64; ++z) {
                ColumnArrayView columnArrayView = columnSource.getVerticalDataPointView(x, z);
                LongArrayList dataColumn = fullDataSource.getColumnAtRelPos(x, z);
                FullDataToRenderDataTransformer.updateOrReplaceRenderDataViewColumnWithFullDataColumn(levelWrapper, fullDataSource, baseX + BitShiftUtil.pow(x, dataDetail), baseZ + BitShiftUtil.pow(z, dataDetail), columnArrayView, dataColumn);
            }
        }
        columnSource.fillDebugFlag(0, 0, 64, 64, ColumnRenderSource.DebugSourceFlag.FULL);
        return columnSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateOrReplaceRenderDataViewColumnWithFullDataColumn(IClientLevelWrapper levelWrapper, FullDataSourceV2 fullDataSource, int blockX, int blockZ, ColumnArrayView columnArrayView, LongArrayList fullDataColumn) {
        if (fullDataColumn == null || fullDataColumn.size() == 0) {
            return;
        }
        int fullDataLength = fullDataColumn.size();
        if (fullDataLength <= columnArrayView.verticalSize()) {
            FullDataToRenderDataTransformer.setRenderColumnView(levelWrapper, fullDataSource, blockX, blockZ, columnArrayView, fullDataColumn);
        } else {
            PhantomArrayListCheckout checkout = ARRAY_LIST_POOL.checkoutArrays(0, 0, 1);
            LongArrayList dataArrayList = checkout.getLongArray(0, fullDataLength);
            try {
                ColumnArrayView newColumnArrayView = new ColumnArrayView(dataArrayList, fullDataLength, 0, fullDataLength);
                FullDataToRenderDataTransformer.setRenderColumnView(levelWrapper, fullDataSource, blockX, blockZ, newColumnArrayView, fullDataColumn);
                columnArrayView.changeVerticalSizeFrom(newColumnArrayView);
            }
            finally {
                ARRAY_LIST_POOL.returnCheckout(checkout);
            }
        }
    }

    private static void setRenderColumnView(IClientLevelWrapper levelWrapper, FullDataSourceV2 fullDataSource, int blockX, int blockZ, ColumnArrayView renderColumnData, LongArrayList fullColumnData) {
        boolean ignoreNonCollidingBlocks = Config.Client.Advanced.Graphics.Quality.blocksToIgnore.get() == EDhApiBlocksToAvoid.NON_COLLIDING;
        boolean colorBelowWithAvoidedBlocks = Config.Client.Advanced.Graphics.Quality.tintWithAvoidedBlocks.get();
        HashSet<IBlockStateWrapper> blockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredBlocks(levelWrapper);
        HashSet<IBlockStateWrapper> caveBlockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredCaveBlocks(levelWrapper);
        if (snowLayerBlockStates == null) {
            snowLayerBlockStates = new HashSet();
            snowLayerBlockStates.add(WRAPPER_FACTORY.deserializeBlockStateWrapperOrGetDefault("minecraft:snow_STATE_{layers:1}", levelWrapper));
            snowLayerBlockStates.add(WRAPPER_FACTORY.deserializeBlockStateWrapperOrGetDefault("minecraft:snow_STATE_{layers:2}", levelWrapper));
            snowLayerBlockStates.add(WRAPPER_FACTORY.deserializeBlockStateWrapperOrGetDefault("minecraft:snow_STATE_{layers:3}", levelWrapper));
        }
        int caveCullingMaxY = Config.Client.Advanced.Graphics.Culling.caveCullingHeight.get() - levelWrapper.getMinHeight();
        boolean caveCullingEnabled = Config.Client.Advanced.Graphics.Culling.enableCaveCulling.get() != false && !levelWrapper.hasCeiling() && !levelWrapper.getDimensionType().isTheEnd();
        boolean isColumnVoid = true;
        int colorToApplyToNextBlock = -1;
        int lastColor = 0;
        int lastBottom = -10000;
        int skylightToApplyToNextBlock = -1;
        int blocklightToApplyToNextBlock = -1;
        int renderDataIndex = 0;
        FullDataPointIdMap fullDataMapping = fullDataSource.mapping;
        DhBlockPosMutable mutableBlockPos = new DhBlockPosMutable(blockX, 0, blockZ);
        for (int fullDataIndex = 0; fullDataIndex < fullColumnData.size(); ++fullDataIndex) {
            long columnData;
            int color;
            boolean ignoreNonSolidBlock;
            IBlockStateWrapper block;
            IBiomeWrapper biome;
            long fullData = fullColumnData.getLong(fullDataIndex);
            int bottomY = FullDataPointUtil.getBottomY(fullData);
            int blockHeight = FullDataPointUtil.getHeight(fullData);
            int topY = bottomY + blockHeight;
            int id = FullDataPointUtil.getId(fullData);
            int blockLight = FullDataPointUtil.getBlockLight(fullData);
            int skyLight = FullDataPointUtil.getSkyLight(fullData);
            mutableBlockPos.setY(bottomY + levelWrapper.getMinHeight());
            try {
                biome = fullDataMapping.getBiomeWrapper(id);
                block = fullDataMapping.getBlockStateWrapper(id);
            }
            catch (IndexOutOfBoundsException e) {
                if (BROKEN_POS_SET.contains(fullDataMapping.getPos())) continue;
                BROKEN_POS_SET.add(fullDataMapping.getPos());
                String levelId = levelWrapper.getDhIdentifier();
                LOGGER.warn("Unable to get data point with id [" + id + "] (Max possible ID: [" + fullDataMapping.getMaxValidId() + "]) for pos [" + fullDataMapping.getPos() + "] in level [" + levelId + "]. Error: [" + e.getMessage() + "]. Further errors for this position won't be logged.", new Object[0]);
                continue;
            }
            boolean ignoreBlock = blockStatesToIgnore.contains(block);
            boolean caveBlock = caveBlockStatesToIgnore.contains(block);
            if (caveBlock) {
                if (caveCullingEnabled && skyLight == 0 && topY < caveCullingMaxY && renderDataIndex != 0 && fullDataIndex != 0 && fullDataIndex + 1 < fullColumnData.size()) {
                    long nextFullData = fullColumnData.getLong(fullDataIndex + 1);
                    int nextSkyLight = FullDataPointUtil.getSkyLight(nextFullData);
                    if (nextSkyLight != 0 || ColorUtil.getAlpha(lastColor) != 255) continue;
                    long columnData2 = renderColumnData.get(renderDataIndex - 1);
                    columnData2 = RenderDataPointUtil.setYMin(columnData2, bottomY);
                    renderColumnData.set(renderDataIndex - 1, columnData2);
                    continue;
                }
                if (ignoreBlock) {
                    continue;
                }
            } else if (ignoreBlock) continue;
            boolean bl = ignoreNonSolidBlock = ignoreNonCollidingBlocks && !block.isSolid() && !block.isLiquid() && block.getOpacity() != 16;
            if (snowLayerBlockStates.contains(block) && --blockHeight == 0) {
                ignoreNonSolidBlock = true;
            }
            if (ignoreNonSolidBlock) {
                int tempColor;
                if (!colorBelowWithAvoidedBlocks || ColorUtil.getAlpha(tempColor = levelWrapper.getBlockColor(mutableBlockPos, biome, fullDataSource, block)) == 0) continue;
                colorToApplyToNextBlock = ColorUtil.setAlpha(tempColor, 255);
                skylightToApplyToNextBlock = skyLight;
                blocklightToApplyToNextBlock = blockLight;
                continue;
            }
            if (colorToApplyToNextBlock == -1) {
                color = levelWrapper.getBlockColor(mutableBlockPos, biome, fullDataSource, block);
            } else {
                color = colorToApplyToNextBlock;
                colorToApplyToNextBlock = -1;
                skyLight = skylightToApplyToNextBlock;
                blockLight = blocklightToApplyToNextBlock;
            }
            if (color == lastColor && bottomY + blockHeight == lastBottom && renderDataIndex > 0) {
                columnData = renderColumnData.get(renderDataIndex - 1);
                columnData = RenderDataPointUtil.setYMin(columnData, bottomY);
                renderColumnData.set(renderDataIndex - 1, columnData);
            } else {
                isColumnVoid = false;
                columnData = RenderDataPointUtil.createDataPoint(bottomY + blockHeight, bottomY, color, skyLight, blockLight, block.getMaterialId());
                renderColumnData.set(renderDataIndex, columnData);
                ++renderDataIndex;
            }
            lastBottom = bottomY;
            lastColor = color;
        }
        if (isColumnVoid) {
            renderColumnData.set(0, 0L);
        }
    }
}

