/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.creeperoverhaul.api.PluginRegistry;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;

public class CreeperAvoidEntitiesGoal
extends Goal {
    private final BaseCreeper creeper;
    private final float maxDistance;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    private Entity entityToAvoid;
    @Nullable
    private Path path;

    public CreeperAvoidEntitiesGoal(BaseCreeper creeper, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
        this.creeper = creeper;
        this.maxDistance = maxDistance;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        List afraidEntities = this.creeper.level().getEntities((Entity)this.creeper, this.creeper.getBoundingBox().inflate((double)this.maxDistance, 3.0, (double)this.maxDistance), this::isAfraidOf);
        this.entityToAvoid = this.getNearestEntity(afraidEntities, (Entity)this.creeper);
        if (this.entityToAvoid == null) {
            return false;
        }
        Vec3 posAway = DefaultRandomPos.getPosAway((PathfinderMob)this.creeper, (int)16, (int)7, (Vec3)this.entityToAvoid.position());
        if (posAway == null) {
            return false;
        }
        if (this.entityToAvoid.distanceToSqr(posAway) < this.entityToAvoid.distanceToSqr((Entity)this.creeper)) {
            return false;
        }
        this.path = this.creeper.getNavigation().createPath(posAway.x, posAway.y, posAway.z, 0);
        return this.path != null;
    }

    public boolean canContinueToUse() {
        return !this.creeper.getNavigation().isDone();
    }

    public void start() {
        this.creeper.getNavigation().moveTo(this.path, this.walkSpeedModifier);
    }

    public void stop() {
        this.entityToAvoid = null;
    }

    public void tick() {
        if (this.entityToAvoid != null) {
            this.creeper.getNavigation().setSpeedModifier(this.creeper.distanceToSqr(this.entityToAvoid) < 49.0 ? this.sprintSpeedModifier : this.walkSpeedModifier);
        }
    }

    @Nullable
    private Entity getNearestEntity(List<Entity> entities, Entity self) {
        if (entities.isEmpty()) {
            return null;
        }
        double lastDist = -1.0;
        Entity lastEntity = null;
        for (Entity entity : entities) {
            double dist = entity.distanceToSqr(self.getX(), self.getY(), self.getZ());
            if (lastDist != -1.0 && !(dist < lastDist)) continue;
            lastEntity = entity;
            lastDist = dist;
        }
        return lastEntity;
    }

    public boolean isAfraidOf(Entity entity) {
        if (this.creeper.type.entitiesAfraidOf().contains(entity.getType())) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return PluginRegistry.getInstance().isAfraidOf(this.creeper, living);
        }
        return false;
    }
}

