/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.Unit;
import team.creative.creativecore.common.util.text.AdvancedStringSplitter;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedContentConsumer;
import team.creative.creativecore.common.util.text.content.FormattedSingleSink;

public class AdvancedComponentHelper {
    public static final AdvancedStringSplitter SPLITTER = new AdvancedStringSplitter(Minecraft.getInstance().font);
    private static final Optional<Object> STOP_ITERATION = Optional.of(Unit.INSTANCE);

    public static Component copy(Component component) {
        MutableComponent copy = MutableComponent.create((ComponentContents)component.getContents());
        for (Component sibling : component.getSiblings()) {
            copy.getSiblings().add(AdvancedComponentHelper.copy(sibling));
        }
        copy.setStyle(component.getStyle());
        return copy;
    }

    public static boolean iterateFormatted(Component text, Style style, final FormattedSingleSink sink) {
        return AdvancedComponentHelper.visit(text, new AdvancedContentConsumer(){

            public Optional accept(Style style, AdvancedContent content) {
                return sink.accept(style, content) ? Optional.empty() : STOP_ITERATION;
            }

            public Optional accept(Style style, String content) {
                return StringDecomposer.iterateFormatted((String)content, (int)0, (Style)style, (Style)style, (FormattedCharSink)sink) ? Optional.empty() : STOP_ITERATION;
            }
        }, style).isEmpty();
    }

    public static <T> Optional<T> visit(Component text, AdvancedContentConsumer<T> consumer, Style defaultStyle) {
        Style style = text.getStyle().applyTo(defaultStyle);
        Optional<T> optional = AdvancedComponentHelper.visit(text.getContents(), consumer, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : text.getSiblings()) {
            Optional<T> optional1 = AdvancedComponentHelper.visit(component, consumer, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    public static <T> Optional<T> visit(ComponentContents content, AdvancedContentConsumer<T> consumer, Style style) {
        if (content instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)content;
            return adv.visit(consumer, style);
        }
        return content.visit(consumer, style);
    }
}

