/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.items;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogwheelBlockItem;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WoodenCogwheelBlockItem
extends BlockItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public WoodenCogwheelBlockItem(CogWheelBlock block, Item.Properties builder) {
        super((Block)block, builder);
        this.large = block.isLargeCog();
        this.placementHelperId = PlacementHelpers.register((IPlacementHelper)(this.large ? new LargeCogHelper() : new SmallCogHelper()));
        this.integratedCogHelperId = PlacementHelpers.register((IPlacementHelper)(this.large ? new CogwheelBlockItem.IntegratedLargeCogHelper() : new CogwheelBlockItem.IntegratedSmallCogHelper()));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperId);
        Player player = context.getPlayer();
        BlockHitResult ray = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, true);
        if (helper.matchesState(state) && player != null && !player.isShiftKeyDown()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, context.getHand(), ray).result();
        }
        if (this.integratedCogHelperId != -1 && (helper = PlacementHelpers.get((int)this.integratedCogHelperId)).matchesState(state) && player != null && !player.isShiftKeyDown()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)this, player, context.getHand(), ray).result();
        }
        return super.onItemUseFirst(stack, context);
    }

    @MethodsReturnNonnullByDefault
    private static class LargeCogHelper
    extends CogwheelBlockItem.DiagonalCogHelper {
        private LargeCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (ICogWheel.isLargeCog((BlockState)state)) {
                Direction.Axis axis = ((IRotate)state.getBlock()).getRotationAxis(state);
                Direction side = (Direction)IPlacementHelper.orderedByDistanceOnlyAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis).get(0);
                List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis);
                for (Direction dir : directions) {
                    BlockPos newPos = pos.relative(dir).relative(side);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)true, (LevelReader)world, (BlockPos)newPos, (Direction.Axis)dir.getAxis()) || !world.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)dir.getAxis()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class SmallCogHelper
    extends CogwheelBlockItem.DiagonalCogHelper {
        private SmallCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!ICogWheel.isLargeCog((BlockState)state)) {
                Direction.Axis axis = ((IRotate)state.getBlock()).getRotationAxis(state);
                List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis);
                for (Direction dir : directions) {
                    BlockPos newPos = pos.relative(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)world, (BlockPos)newPos, (Direction.Axis)axis) || !world.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }
}

