/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing;

import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import fr.iglee42.createcasing.CreateCasingClient;
import fr.iglee42.createcasing.commands.CreateCasingCommand;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.kubejs.KJSExternalHandler;
import fr.iglee42.createcasing.mixins.create.DeployerBlockEntityAccessor;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import fr.iglee42.createcasing.registries.EncasedBlocks;
import fr.iglee42.createcasing.registries.EncasedCreativeModeTabs;
import fr.iglee42.createcasing.registries.EncasedItems;
import fr.iglee42.createcasing.registries.EncasedPackets;
import fr.iglee42.createcasing.registries.EncasedRecipeGens;
import fr.iglee42.createcasing.registries.EncasedSounds;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="createcasing")
public class CreateCasing {
    public static final String MODID = "createcasing";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"createcasing");
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createcasing").defaultCreativeTab((ResourceKey)null);
    public static List<ItemLike> hidedItems = new ArrayList<ItemLike>();
    public static KJSExternalHandler KJS_HANDLER = () -> {};

    public CreateCasing(IEventBus modEventBus, ModContainer container) {
        IEventBus neoForgeEventBus = NeoForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        EncasedSounds.prepare();
        EncasedBlocks.register();
        EncasedItems.register();
        EncasedBlockEntities.register();
        EncasedCreativeModeTabs.register(modEventBus);
        EncasedPackets.register();
        ModConfigs.register(ModLoadingContext.get(), container);
        RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateCasingClient.onCtorClient(modEventBus));
        neoForgeEventBus.addListener(this::registerCommands);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(EncasedSounds::register);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(EventPriority.LOWEST, this::gatherData);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static void hideItem(ItemLike it) {
        hidedItems.add(it);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void registerCommands(RegisterCommandsEvent event) {
        if (!FMLEnvironment.production) {
            new CreateCasingCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EncasedBlockEntities.DEPOT.get(), (be, context) -> ((DepotBehaviour)be.getBehaviour((BehaviourType)DepotBehaviour.TYPE)).itemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)EncasedBlockEntities.DEPLOYER.get(), (be, context) -> {
            DeployerBlockEntityAccessor accessor = (DeployerBlockEntityAccessor)be;
            if (accessor.getInvHandler() == null) {
                accessor.invokeInitHandler();
            }
            return accessor.getInvHandler();
        });
    }

    private void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new EncasedRecipeGens(event.getGenerator().getPackOutput(), event.getLookupProvider()));
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

