/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public class CreateCasingCommand {
    public CreateCasingCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"createcasing").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"placeAllBlocks").requires(c -> c.hasPermission(4))).executes(this::placeBlocks)).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.string()).executes(this::placeBlocksWithFilter))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cc").requires(c -> c.hasPermission(4))).redirect((CommandNode)command));
    }

    private int placeBlocks(CommandContext<CommandSourceStack> source) {
        ServerLevel level = ((CommandSourceStack)source.getSource()).getLevel();
        if (!((CommandSourceStack)source.getSource()).isPlayer()) {
            return 0;
        }
        AtomicInteger x = new AtomicInteger();
        AtomicInteger y = new AtomicInteger();
        BuiltInRegistries.BLOCK.keySet().stream().filter(k -> k.getNamespace().equals("createcasing")).forEach(k -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(k);
            if (block != null) {
                BlockPos pos = ((CommandSourceStack)source.getSource()).getPlayer().blockPosition().offset(x.get(), y.get(), 0);
                level.setBlockAndUpdate(pos, block.defaultBlockState());
                x.getAndIncrement();
                if (x.get() > 16) {
                    x.set(0);
                    y.getAndIncrement();
                }
            }
        });
        return 1;
    }

    private int placeBlocksWithFilter(CommandContext<CommandSourceStack> source) {
        ServerLevel level = ((CommandSourceStack)source.getSource()).getLevel();
        if (!((CommandSourceStack)source.getSource()).isPlayer()) {
            return 0;
        }
        AtomicInteger x = new AtomicInteger();
        AtomicInteger y = new AtomicInteger();
        String filter = (String)source.getArgument("filter", String.class);
        List<ResourceLocation> blocks = BuiltInRegistries.BLOCK.keySet().stream().filter(k -> k.getNamespace().equals("createcasing") && k.getPath().contains((CharSequence)source.getArgument("filter", String.class))).toList();
        if (filter.startsWith("/") && filter.endsWith("/")) {
            String regex = filter.substring(1, filter.length() - 1);
            blocks = BuiltInRegistries.BLOCK.keySet().stream().filter(k -> k.getNamespace().equals("createcasing") && k.getPath().matches(regex)).toList();
        }
        blocks.forEach(k -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(k);
            if (block != null) {
                BlockPos pos = ((CommandSourceStack)source.getSource()).getPlayer().blockPosition().offset(x.get(), y.get(), 0);
                level.setBlockAndUpdate(pos, block.defaultBlockState());
                x.getAndIncrement();
                if (x.get() > 16) {
                    x.set(0);
                    y.getAndIncrement();
                }
            }
        });
        return 1;
    }
}

