/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModFingerprinter;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.CommentedConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.Config;
import dev.kostromdan.mods.crash_assistant.nightconfig.json.JsonParser;
import dev.kostromdan.mods.crash_assistant.nightconfig.toml.TomlParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class ModDataParser {
    public static final List<String> inJarPaths = PlatformHelp.getOrderedInJarPaths();
    private static final Path CACHE_FOLDER = Paths.get("local", "crash_assistant", "mod_data_cache_v3");
    private static final Gson GSON = new Gson();

    private static Path getCacheFilePath(Path jarPath) {
        return CACHE_FOLDER.resolve(jarPath.getFileName().toString() + ".mod_data.json");
    }

    /*
     * Exception decompiling
     */
    public static Mod getModFromCache(Path jarPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveModToCache(Path jarPath, Mod mod) {
        Path cacheFilePath = ModDataParser.getCacheFilePath(jarPath);
        try (RandomAccessFile raf = new RandomAccessFile(cacheFilePath.toFile(), "rw");
             FileChannel ch = raf.getChannel();
             FileLock ignored = ch.lock();){
            ch.truncate(0L);
            ch.write(ByteBuffer.wrap(GSON.toJson((Object)mod).getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.error("Failed to save mod data to cache for " + String.valueOf(jarPath), (Throwable)e);
        }
    }

    public static Mod parseModData(Path jarPath) {
        Mod mod;
        Mod cached = ModDataParser.getModFromCache(jarPath);
        if (cached != null) {
            return cached;
        }
        ModFingerprinter.IdentificationResult fingerprints = ModDataParser.fingerprintJar(jarPath);
        JarFile jarFile = new JarFile(jarPath.toFile());
        try {
            Mod mod2 = ModDataParser.parseJarFile(jarFile, jarPath.getFileName().toString(), null, fingerprints);
            ModDataParser.saveModToCache(jarPath, mod2);
            mod = mod2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                JarInJarHelper.LOGGER.warn("Failed to parse " + String.valueOf(jarPath.getFileName()) + ": ", (Throwable)e);
                return new Mod(jarPath.getFileName().toString(), null, null, null, new HashSet<String>(), new ArrayList<Mod>(), null, ModDataParser.getCurseForgeHash(fingerprints, null), ModDataParser.getModrinthHash(fingerprints, null));
            }
        }
        jarFile.close();
        return mod;
    }

    private static ModFingerprinter.IdentificationResult fingerprintJar(Path jarPath) {
        try {
            return ModFingerprinter.identify(jarPath);
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.warn("Failed to fingerprint " + String.valueOf(jarPath.getFileName()) + ": ", (Throwable)e);
            return null;
        }
    }

    private static Long getCurseForgeHash(ModFingerprinter.IdentificationResult fingerprints, String jarJarPath) {
        return jarJarPath == null && fingerprints != null ? Long.valueOf(fingerprints.getCurseForgeHash()) : null;
    }

    private static String getModrinthHash(ModFingerprinter.IdentificationResult fingerprints, String jarJarPath) {
        return jarJarPath == null && fingerprints != null ? fingerprints.getModrinthHash() : null;
    }

    private static Mod parseJarFile(JarFile jarFile, String currentJarName, String jarJarPath, ModFingerprinter.IdentificationResult fingerprints) {
        Boolean isMCreator = null;
        boolean hasEssentialLoader = false;
        HashSet<String> mixinConfigs = new HashSet<String>();
        ArrayList<Mod> jarInJarMods = new ArrayList<Mod>();
        try {
            if (jarFile.getEntry("net/mcreator/") != null) {
                isMCreator = true;
            }
            if (jarFile.getEntry("essential-loader.properties") != null) {
                hasEssentialLoader = true;
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                if (name.startsWith("META-INF/") && name.endsWith(".jar")) {
                    ModDataParser.processNestedJar(name, () -> ModDataParser.readEntryBytes(jarFile, entry), jarInJarMods);
                    continue;
                }
                if (!name.endsWith(".json") || !name.substring(name.lastIndexOf(47) + 1).contains("mixin") || name.startsWith("data/")) continue;
                mixinConfigs.add(name);
            }
            HashMap<String, byte[]> descriptorBytes = new HashMap<String, byte[]>();
            Manifest manifest = null;
            for (String descriptorPath : inJarPaths) {
                JarEntry entry = jarFile.getJarEntry(descriptorPath);
                if (entry == null) continue;
                descriptorBytes.put(descriptorPath, ModDataParser.readEntryBytes(jarFile, entry));
            }
            ManifestProvider manifestProvider = () -> {
                if (manifest == null) {
                    return jarFile.getManifest();
                }
                return manifest;
            };
            if (descriptorBytes.isEmpty()) {
                JarInJarHelper.LOGGER.warn("No descriptors found in " + currentJarName);
            }
            return ModDataParser.parseDescriptorsAndBuildMod(descriptorBytes, manifestProvider, currentJarName, jarJarPath, isMCreator, hasEssentialLoader, mixinConfigs, jarInJarMods, fingerprints);
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.warn("Failed while processing " + currentJarName, (Throwable)e);
            return new Mod(currentJarName, null, null, isMCreator, mixinConfigs, jarInJarMods, jarJarPath, ModDataParser.getCurseForgeHash(fingerprints, jarJarPath), ModDataParser.getModrinthHash(fingerprints, jarJarPath));
        }
    }

    private static Mod parseJarFile(JarInputStream jis, String currentJarName, String jarJarPath) {
        Boolean isMCreator = null;
        boolean hasEssentialLoader = false;
        HashSet<String> mixinConfigs = new HashSet<String>();
        ArrayList<Mod> jarInJarMods = new ArrayList<Mod>();
        HashMap<String, byte[]> descriptorBytes = new HashMap<String, byte[]>();
        try {
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (isMCreator == null && name.startsWith("net/mcreator")) {
                    isMCreator = true;
                }
                if ("essential-loader.properties".equals(name)) {
                    hasEssentialLoader = true;
                }
                if (name.startsWith("META-INF/") && name.endsWith(".jar")) {
                    ModDataParser.processNestedJar(name, () -> ModDataParser.readEntryBytes(jis), jarInJarMods);
                    continue;
                }
                if (inJarPaths.contains(name)) {
                    descriptorBytes.put(name, ModDataParser.readEntryBytes(jis));
                    continue;
                }
                if (!name.endsWith(".json") || !name.substring(name.lastIndexOf(47) + 1).contains("mixin") || name.startsWith("data/")) continue;
                mixinConfigs.add(name);
            }
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.warn("Failed while streaming entries of " + currentJarName, (Throwable)e);
        }
        ManifestProvider manifestProvider = () -> jis.getManifest();
        return ModDataParser.parseDescriptorsAndBuildMod(descriptorBytes, manifestProvider, currentJarName, jarJarPath, isMCreator, hasEssentialLoader, mixinConfigs, jarInJarMods, null);
    }

    private static void processNestedJar(String name, ByteSupplier byteSupplier, List<Mod> jarInJarMods) {
        String nestedJarName = name.substring(name.lastIndexOf(47) + 1);
        String normalizedNestedJarName = nestedJarName.toLowerCase();
        if (normalizedNestedJarName.contains("mixinextras") || normalizedNestedJarName.contains("mixinsquared")) {
            return;
        }
        String nestedJarPath = "/" + (name.contains("/") ? name.substring(0, name.lastIndexOf(47) + 1) : "");
        try {
            byte[] nestedBytes = byteSupplier.get();
            try (JarInputStream nestedJis = new JarInputStream(new ByteArrayInputStream(nestedBytes));){
                Mod nested = ModDataParser.parseJarFile(nestedJis, nestedJarName, nestedJarPath);
                nested = new Mod(nestedJarName, nested.getModId(), nested.getVersion(), nested.IsMCreator(), nested.getMixinConfigs(), nested.getJarJarMods(), nestedJarPath);
                jarInJarMods.add(nested);
            }
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.warn("Error processing nested jar " + name + ": " + e.getMessage());
            jarInJarMods.add(new Mod(nestedJarName, null, null, null, new HashSet<String>(), new ArrayList<Mod>(), nestedJarPath));
        }
    }

    private static Mod parseDescriptorsAndBuildMod(Map<String, byte[]> descriptorBytes, ManifestProvider manifestProvider, String currentJarName, String jarJarPath, Boolean isMCreator, boolean hasEssentialLoader, HashSet<String> mixinConfigs, List<Mod> jarInJarMods, ModFingerprinter.IdentificationResult fingerprints) {
        for (String descriptorPath : inJarPaths) {
            byte[] bytes = descriptorBytes.get(descriptorPath);
            if (bytes == null) continue;
            try {
                ParsedModInfo modInfo;
                Config cfg = ModDataParser.loadConfigFromBytes(currentJarName + "/" + descriptorPath, bytes);
                if (cfg == null || (modInfo = ModDataParser.parseModConfig(cfg, descriptorPath, manifestProvider, mixinConfigs)) == null) continue;
                if (modInfo.version == null && modInfo.modId == null) {
                    throw new Exception("Failed to parse mod data (version AND modId) from " + descriptorPath + " of " + currentJarName);
                }
                if (modInfo.version == null) {
                    JarInJarHelper.LOGGER.warn("Failed to parse version from " + descriptorPath + " of " + currentJarName);
                }
                if (modInfo.modId == null) {
                    JarInJarHelper.LOGGER.warn("Failed to parse modId from " + descriptorPath + " of " + currentJarName);
                }
                return new Mod(currentJarName, modInfo.modId, modInfo.version, isMCreator, mixinConfigs, jarInJarMods, jarJarPath, ModDataParser.getCurseForgeHash(fingerprints, jarJarPath), ModDataParser.getModrinthHash(fingerprints, jarJarPath));
            }
            catch (Exception e) {
                JarInJarHelper.LOGGER.warn("Error parsing " + descriptorPath + " of " + currentJarName + ": ", (Throwable)e);
            }
        }
        if (currentJarName.toLowerCase().contains("essential") && hasEssentialLoader) {
            return new Mod(currentJarName, "essential-container", null, isMCreator, mixinConfigs, jarInJarMods, jarJarPath, ModDataParser.getCurseForgeHash(fingerprints, jarJarPath), ModDataParser.getModrinthHash(fingerprints, jarJarPath));
        }
        return new Mod(currentJarName, null, null, isMCreator, mixinConfigs, jarInJarMods, jarJarPath, ModDataParser.getCurseForgeHash(fingerprints, jarJarPath), ModDataParser.getModrinthHash(fingerprints, jarJarPath));
    }

    private static ParsedModInfo parseModConfig(Config cfg, String descriptorPath, ManifestProvider manifestProvider, HashSet<String> mixinConfigs) throws IOException {
        String modId;
        Config mods;
        ManifestParsingResult mp = null;
        if (descriptorPath.endsWith(".toml")) {
            List modsList = (List)cfg.get("mods");
            if (modsList == null || modsList.isEmpty()) {
                return null;
            }
            mods = (Config)modsList.get(0);
            modId = (String)mods.get("modId");
            if ("META-INF/neoforge.mods.toml".equals(descriptorPath)) {
                List mixinsList = (List)cfg.get("mixins");
                if (mixinsList != null) {
                    for (Object obj : mixinsList) {
                        String c;
                        if (!(obj instanceof Config) || (c = (String)((Config)obj).get("config")) == null) continue;
                        mixinConfigs.add(c);
                    }
                }
            } else {
                mp = ModDataParser.parseManifest(manifestProvider.get());
                if (mp != null) {
                    mixinConfigs.addAll(mp.getMixinConfigs());
                }
            }
        } else if (descriptorPath.endsWith(".json")) {
            mods = cfg;
            modId = (String)mods.get("id");
            Object mixinsObj = mods.get("mixins");
            if (mixinsObj instanceof List) {
                mixinConfigs.addAll(((List)mixinsObj).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList()));
            }
        } else if (descriptorPath.endsWith(".info")) {
            List modsList = (List)cfg.get("mods");
            if (modsList == null || modsList.isEmpty()) {
                return null;
            }
            mods = (Config)modsList.get(0);
            modId = (String)mods.get("modid");
        } else {
            throw new IllegalArgumentException("Unsupported descriptor file extension: " + descriptorPath);
        }
        String version = (String)mods.get("version");
        if (Objects.equals(version, "${file.jarVersion}")) {
            if (mp == null) {
                mp = ModDataParser.parseManifest(manifestProvider.get());
            }
            version = mp == null ? null : mp.getImplementationVersion();
        } else if (Objects.equals(version, "${modVersion}")) {
            version = null;
        }
        return new ParsedModInfo(modId, version);
    }

    private static byte[] readEntryBytes(JarInputStream jis) throws Exception {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((r = jis.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    private static byte[] readEntryBytes(JarFile jarFile, JarEntry entry) throws Exception {
        try (InputStream is = jarFile.getInputStream(entry);){
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((r = is.read(buf)) != -1) {
                out.write(buf, 0, r);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Config loadConfigFromBytes(String descriptorPath, byte[] bytes) {
        try {
            JsonArray arr;
            JsonObject rootObject;
            if (descriptorPath.endsWith(".toml")) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);){
                    CommentedConfig commentedConfig = new TomlParser().parse(reader);
                    return commentedConfig;
                }
            }
            if (descriptorPath.endsWith(".json")) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);){
                    Config config = new JsonParser().parse(reader);
                    return config;
                }
            }
            if (!descriptorPath.endsWith(".info")) throw new IllegalArgumentException("Unsupported descriptor file extension: " + descriptorPath);
            Object content = new String(bytes, StandardCharsets.UTF_8);
            String modId = null;
            String version = null;
            JsonElement root = new com.google.gson.JsonParser().parse((String)content);
            JsonObject obj = null;
            if (root.isJsonArray()) {
                JsonArray arr2 = root.getAsJsonArray();
                if (arr2.size() > 0 && arr2.get(0).isJsonObject()) {
                    obj = arr2.get(0).getAsJsonObject();
                }
            } else if (root.isJsonObject() && (rootObject = root.getAsJsonObject()).has("modList") && (arr = rootObject.getAsJsonArray("modList")).size() > 0 && arr.get(0).isJsonObject()) {
                obj = arr.get(0).getAsJsonObject();
            }
            if (obj != null) {
                if (obj.has("modid") && !obj.get("modid").isJsonNull()) {
                    modId = obj.get("modid").getAsString();
                }
                if (obj.has("version") && !obj.get("version").isJsonNull()) {
                    version = obj.get("version").getAsString();
                }
            }
            ArrayList<CallSite> needed = new ArrayList<CallSite>();
            if (modId != null) {
                needed.add((CallSite)((Object)("\"modid\": \"" + modId + "\"")));
            }
            if (version != null) {
                needed.add((CallSite)((Object)("\"version\": \"" + version + "\"")));
            }
            content = "{\"mods\":[{" + String.join((CharSequence)",", needed) + "}]}";
            try (StringReader reader = new StringReader((String)content);){
                Config config = new JsonParser().parse(reader);
                return config;
            }
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.warn("Failed to parse descriptor " + descriptorPath + " in\u2011memory", (Throwable)e);
            return null;
        }
    }

    private static ManifestParsingResult parseManifest(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        Attributes a = manifest.getMainAttributes();
        String implVer = a.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        ArrayList<String> mixin = new ArrayList<String>();
        String mixinCfgs = a.getValue("MixinConfigs");
        if (mixinCfgs != null) {
            for (String s : mixinCfgs.split(",")) {
                String t = s.trim();
                if (t.isEmpty()) continue;
                mixin.add(t);
            }
        }
        return new ManifestParsingResult(implVer, mixin);
    }

    static {
        try {
            Files.createDirectories(CACHE_FOLDER, new FileAttribute[0]);
        }
        catch (Exception e) {
            JarInJarHelper.LOGGER.error("Failed to create cache directory", (Throwable)e);
        }
    }

    private static interface ByteSupplier {
        public byte[] get() throws Exception;
    }

    private static interface ManifestProvider {
        public Manifest get() throws IOException;
    }

    private static class ParsedModInfo {
        final String modId;
        final String version;

        ParsedModInfo(String modId, String version) {
            this.modId = modId;
            this.version = version;
        }
    }

    public static class ManifestParsingResult {
        private final String implementationVersion;
        private final List<String> mixinConfigs;

        public ManifestParsingResult(String implementationVersion, List<String> mixinConfigs) {
            this.implementationVersion = implementationVersion;
            this.mixinConfigs = mixinConfigs;
        }

        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        public List<String> getMixinConfigs() {
            return this.mixinConfigs;
        }
    }
}

