/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.integrations.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.client.KeybindHandler;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.integrations.jei.category.UpgradeCategory;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.recipe.SmithingApplyUpgradeRecipe;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ConstructionStickJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ConstructionStick.modLoc("constructionstick");
    private static final String baseKey = "constructionstick.description.";
    private static final String baseKeyItem = "item.constructionstick.";

    @NotNull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableSmithingRecipeCategory smithingCategory = registration.getSmithingCategory();
        smithingCategory.addExtension(SmithingApplyUpgradeRecipe.class, (ISmithingCategoryExtension)new UpgradeCategory());
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        MutableComponent stickChangeUpgradeKey = Component.translatable((String)KeybindHandler.KEY_CHANGE_UPGRADE.getName()).withStyle(ChatFormatting.BLUE);
        MutableComponent stickOpenGuiKey = Component.translatable((String)KeybindHandler.KEY_OPEN_GUI.getName()).withStyle(ChatFormatting.BLUE);
        MutableComponent stickUndoKey = Component.translatable((String)KeybindHandler.KEY_UNDO.getName()).withStyle(ChatFormatting.BLUE);
        MutableComponent stickShowPrevious = Component.translatable((String)KeybindHandler.KEY_SHOW_PREVIOUS.getName()).withStyle(ChatFormatting.BLUE);
        for (DeferredItem<ItemStick> deferredItem : ModItems.STICKS) {
            Item stick = (Item)deferredItem.get();
            ConstructionConfig.StickProperties stickProperties = ConstructionConfig.getStickProperties(stick);
            MutableComponent durabilityComponent = Component.translatable((String)"constructionstick.description.durability.limited", (Object[])new Object[]{stickProperties.getDurability()});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)stick), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"constructionstick.description.stick", (Object[])new Object[]{Component.translatable((String)(baseKeyItem + BuiltInRegistries.ITEM.getKey((Object)stick).getPath())), stickProperties.getLimit(), durabilityComponent, stickChangeUpgradeKey, stickOpenGuiKey, stickShowPrevious, stickUndoKey, stickOpenGuiKey})});
        }
        for (DeferredItem deferredItem : ModItems.TEMPLATES) {
            Item upgradeTemplate = (Item)deferredItem.get();
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)upgradeTemplate), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)(baseKey + BuiltInRegistries.ITEM.getKey((Object)upgradeTemplate).getPath())).append("\n\n").append((Component)Component.translatable((String)"constructionstick.description.upgrade", (Object[])new Object[]{stickChangeUpgradeKey}))});
        }
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        for (DeferredItem<ItemStick> deferredStick : ModItems.STICKS) {
            registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, (Object)deferredStick.toStack(), List.of("construction", "wand", "construction wand"));
        }
    }
}

