/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics.pool;

import java.util.HashMap;
import java.util.HashSet;
import mrbysco.constructionstick.basics.pool.IPool;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class RandomPool<T>
implements IPool<T> {
    private final RandomSource rng;
    private final HashMap<T, Integer> elements;
    private HashSet<T> pool;

    public RandomPool(RandomSource rng) {
        this.rng = rng;
        this.elements = new HashMap();
        this.reset();
    }

    @Override
    public void add(T element) {
        this.addWithWeight(element, 1);
    }

    @Override
    public void remove(T element) {
        this.elements.remove(element);
        this.pool.remove(element);
    }

    public void addWithWeight(T element, int weight) {
        if (weight < 1) {
            return;
        }
        this.elements.merge(element, weight, Integer::sum);
        this.pool.add(element);
    }

    @Override
    @Nullable
    public T draw() {
        int allWeights = this.pool.stream().reduce(0, (partialRes, e) -> partialRes + this.elements.get(e), Integer::sum);
        if (allWeights < 1) {
            return null;
        }
        int random = this.rng.nextInt(allWeights);
        int accWeight = 0;
        for (T e2 : this.pool) {
            if (random >= (accWeight += this.elements.get(e2).intValue())) continue;
            this.pool.remove(e2);
            return e2;
        }
        return null;
    }

    @Override
    public void reset() {
        this.pool = new HashSet<T>(this.elements.keySet());
    }
}

