/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.plugins.journeyplugin.core;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.properties.CoreProperties;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class MappingTask
implements Runnable {
    List<LevelChunk> chunks;
    ResourceKey<Level> level;

    public MappingTask(List<LevelChunk> chunks, ResourceKey<Level> level) {
        this.chunks = chunks;
        this.level = level;
    }

    @Override
    public void run() {
        boolean biomeAllowed;
        JourneymapClient client = JourneymapClient.getInstance();
        CoreProperties props = client.getCoreProperties();
        boolean surfaceAllowed = FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        boolean cavesAllowed = FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        boolean topoAllowed = FeatureManager.getInstance().isAllowed(Feature.MapTopo) && props.mapTopography.get() != false;
        boolean bl = biomeAllowed = FeatureManager.getInstance().isAllowed(Feature.MapBiome) && props.mapBiome.get() != false;
        if (!(surfaceAllowed || cavesAllowed || topoAllowed || biomeAllowed)) {
            return;
        }
        EntityDTO player = DataCache.getPlayer();
        Entity playerEntity = (Entity)player.entityRef.get();
        if (playerEntity == null) {
            return;
        }
        ObjectArrayList maps = new ObjectArrayList();
        if (surfaceAllowed) {
            maps.add(MapType.day(this.level));
            maps.add(MapType.night(this.level));
        }
        if (cavesAllowed) {
            maps.add(MapType.underground((EntityDTO)player));
        }
        if (biomeAllowed) {
            maps.add(MapType.biome(this.level));
        }
        if (topoAllowed) {
            maps.add(MapType.topo(this.level));
        }
        File file = FileHandler.getJMWorldDir((Minecraft)Minecraft.getInstance());
        ObjectArrayList mdChunks = new ObjectArrayList();
        for (LevelChunk chunk : this.chunks) {
            mdChunks.add(new ChunkMD(chunk));
        }
        mdChunks.forEach(arg_0 -> ((DataCache)DataCache.INSTANCE).addChunkMD(arg_0));
        for (LevelChunk chunk : mdChunks) {
            for (MapType type : maps) {
                RegionCoord rCoord = RegionCoord.fromChunkPos((File)file, (MapType)type, (int)chunk.getCoord().x, (int)chunk.getCoord().z);
                RegionDataStorageHandler.Key key = new RegionDataStorageHandler.Key(rCoord, type);
                RegionData regionData = RegionDataStorageHandler.getInstance().getRegionData(key);
                try {
                    JourneymapClient.getInstance().getChunkRenderController().renderChunk(rCoord, type, (ChunkMD)chunk, regionData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        mdChunks.forEach(arg_0 -> ((DataCache)DataCache.INSTANCE).removeChunkMD(arg_0));
        RegionImageCache.INSTANCE.flushToDiskAsync(true);
        DataCache.INSTANCE.stopChunkMDRetention();
    }
}

