/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.plugins.journeyplugin.core;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.IOverlayListener;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.event.PopupMenuEvent;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.commands.DeleteCommandScreen;
import pregenerator.client.gui.commands.GenCommandScreen;
import pregenerator.common.base.PregenEvent;
import pregenerator.common.base.PregenTaskEvent;
import pregenerator.common.deleter.tasks.DeletionSpecific;
import pregenerator.common.deleter.tasks.DeletionSquareArea;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.SquareAreaTask;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.plugins.journeyplugin.core.DeletionTask;
import pregenerator.plugins.journeyplugin.core.MappingTask;

public class EventListener {
    Map<UUID, Long2ObjectMap<List<LevelChunk>>> progressCache = new Object2ObjectOpenHashMap();
    DimensionPos deletionMarker = new DimensionPos("Area To delete", this::processDeleter);
    DimensionPos generationMarker = new DimensionPos("Area to pregen", this::processGenerator);

    public static EventListener init() {
        EventListener instance = new EventListener();
        ClientEventRegistry.FULLSCREEN_POPUP_MENU_EVENT.subscribe("chunkpregen", instance::onMenuSelected);
        return instance;
    }

    @SubscribeEvent
    public void onChunkGenerated(PregenEvent.Generated event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null || event.getTaskId() == null || !event.getWorld().dimension().equals(mc.level.dimension())) {
            return;
        }
        ChunkAccess access = event.getChunk();
        if (access instanceof LevelChunk) {
            Long2ObjectMap chunks = this.progressCache.computeIfAbsent(event.getTaskId(), T -> new Long2ObjectOpenHashMap());
            ChunkPos pos = access.getPos();
            long region = ChunkPos.asLong((int)pos.getRegionX(), (int)pos.getRegionZ());
            ((List)chunks.computeIfAbsent(region, T -> new ObjectArrayList())).add(this.toClientChunk((LevelChunk)access, (Level)mc.level));
        }
    }

    @SubscribeEvent
    public void onRegionFinished(PregenEvent.RegionFinished event) {
        Long2ObjectMap<List<LevelChunk>> chunks = this.progressCache.get(event.getTaskId());
        if (chunks == null) {
            return;
        }
        ChunkPos pos = event.getRegionPos();
        long region = ChunkPos.asLong((int)pos.getRegionX(), (int)pos.getRegionZ());
        List result = (List)chunks.remove(region);
        if (chunks.isEmpty()) {
            this.progressCache.remove(event.getTaskId());
        }
        if (result == null) {
            return;
        }
        JourneymapClient map = JourneymapClient.getInstance();
        if (!map.isMapping().booleanValue()) {
            map.startMapping();
        }
        try {
            map.queueOneOff((Runnable)new MappingTask(result, (ResourceKey<Level>)event.getWorld().dimension()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onChunksDeleted(PregenEvent.ChunksDeleted event) {
        JourneymapClient map = JourneymapClient.getInstance();
        if (!map.isMapping().booleanValue()) {
            map.startMapping();
        }
        try {
            map.queueOneOff((Runnable)new DeletionTask(event.getChunks(), event.getDimension()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onGuiOpenEvent(ScreenEvent.Closing event) {
        if (event.getScreen() instanceof Fullscreen) {
            this.deletionMarker.clear();
            this.generationMarker.clear();
        }
    }

    @SubscribeEvent
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.deletionMarker.updateMouse();
        this.generationMarker.updateMouse();
    }

    public void onMenuSelected(PopupMenuEvent.FullscreenPopupMenuEvent event) {
        ModPopupMenu main = event.getPopupMenu().createSubItemList("Pregen");
        ModPopupMenu pregen = main.createSubItemList("Gen");
        pregen.addMenuItem("Open Pregen Menu", this::openGenerator);
        pregen.addMenuItem("Generate Region File", this::generateRegion);
        pregen.addMenuItem("Generate Area", this::generateArea);
        ModPopupMenu delete = main.createSubItemList("Deleter");
        delete.addMenuItem("Open Deleter Menu", this::openDeleter);
        delete.addMenuItem("Delete Chunk", this::deleteChunk);
        delete.addMenuItem("Delete Region File", this::deleteRegion);
        delete.addMenuItem("Delete Area", this::deleteArea);
    }

    private Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    private void openDeleter(BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        DeleteCommandScreen screen = new DeleteCommandScreen(mc.screen);
        screen.setCoordinates((ResourceKey<Level>)level.dimension(), new ChunkPos(pos));
        mc.setScreen((Screen)screen);
    }

    private void openGenerator(BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        GenCommandScreen screen = GenCommandScreen.CREATOR.apply(mc.screen);
        screen.setCoordinates((ResourceKey<Level>)level.dimension(), new ChunkPos(pos));
        mc.setScreen((Screen)screen);
    }

    private void deleteChunk(BlockPos pos) {
        Level level = this.getClientLevel();
        if (level == null) {
            return;
        }
        ChunkPos chunk = new ChunkPos(pos);
        Minecraft mc = Minecraft.getInstance();
        Screen current = mc.screen;
        ConfirmScreen screen = new ConfirmScreen(T -> {
            if (T) {
                NetworkManager.INSTANCE.sendToServer(new CommandPacket.DeletionTask(new DeletionSpecific("journeyMap_chunk_" + chunk.x + "_" + chunk.z, (ResourceKey<Level>)level.dimension(), LongLists.singleton((long)chunk.toLong()))));
            }
            mc.setScreen(current);
        }, (Component)TextUtil.translate("journey.chunk_pregen.generator.header").withStyle(ChatFormatting.RED), (Component)TextUtil.translate("journey.chunk_pregen.chunk.body", chunk.x, chunk.z).withStyle(ChatFormatting.GRAY));
        mc.setScreen((Screen)screen);
    }

    private void deleteRegion(BlockPos pos) {
        Level level = this.getClientLevel();
        if (level == null) {
            return;
        }
        ChunkPos chunk = new ChunkPos(pos);
        LongArrayList output = new LongArrayList();
        int xOff = chunk.getRegionX() << 5;
        int zOff = chunk.getRegionZ() << 5;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                output.add(ChunkPos.asLong((int)(x + xOff), (int)(z + zOff)));
            }
        }
        Minecraft mc = Minecraft.getInstance();
        Screen current = mc.screen;
        ConfirmScreen screen = new ConfirmScreen(arg_0 -> EventListener.lambda$deleteRegion$3(chunk, level, (LongList)output, mc, current, arg_0), (Component)TextUtil.translate("journey.chunk_pregen.generator.header").withStyle(ChatFormatting.RED), (Component)TextUtil.translate("journey.chunk_pregen.region.body", chunk.getRegionX(), chunk.getRegionZ()).withStyle(ChatFormatting.GRAY));
        mc.setScreen((Screen)screen);
    }

    private void deleteArea(BlockPos pos) {
        Level level = this.getClientLevel();
        if (level == null) {
            return;
        }
        this.deletionMarker.setFrom(level, pos);
        this.generationMarker.clear();
    }

    private void processDeleter(DimensionPos deletionMarker) {
        if (!deletionMarker.canExecute()) {
            return;
        }
        ResourceKey<Level> dimension = deletionMarker.dimension;
        BlockPos from = deletionMarker.from();
        BlockPos to = deletionMarker.to();
        Minecraft mc = Minecraft.getInstance();
        Screen current = mc.screen;
        ConfirmScreen screen = new ConfirmScreen(T -> {
            if (T) {
                ChunkPos pos = new ChunkPos(from);
                DeletionSquareArea task = new DeletionSquareArea("journeyMap_delete_area_" + pos.x + "_" + pos.z, dimension, pos, new ChunkPos(to));
                NetworkManager.INSTANCE.sendToServer(new CommandPacket.DeletionTask(task));
            }
            mc.setScreen(current);
        }, (Component)TextUtil.translate("journey.chunk_pregen.generator.header").withStyle(ChatFormatting.RED), (Component)TextUtil.translate("journey.chunk_pregen.deleter.body", from.getX(), from.getZ(), to.getX(), to.getZ()).withStyle(ChatFormatting.GRAY));
        mc.setScreen((Screen)screen);
    }

    private void generateRegion(BlockPos pos) {
        Level level = this.getClientLevel();
        if (level == null) {
            return;
        }
        ChunkPos chunk = new ChunkPos(pos);
        int minX = chunk.getRegionX() << 5;
        int minZ = chunk.getRegionZ() << 5;
        int maxX = minX + 32;
        int maxZ = minZ + 32;
        Minecraft mc = Minecraft.getInstance();
        Screen current = mc.screen;
        ConfirmScreen screen = new ConfirmScreen(T -> {
            if (T) {
                NetworkManager.INSTANCE.sendToServer(new CommandPacket.GenTask(new SquareAreaTask("journeyMap_region_" + chunk.getRegionX() + "_" + chunk.getRegionZ(), (ResourceKey<Level>)level.dimension(), GenerationType.NORMAL_GEN.ordinal(), new ChunkPos(minX, minZ), new ChunkPos(maxX, maxZ))));
            }
            mc.setScreen(current);
        }, (Component)TextUtil.translate("journey.chunk_pregen.generator.header").withStyle(ChatFormatting.RED), (Component)TextUtil.translate("journey.chunk_pregen.pregen_region.body", chunk.getRegionX(), chunk.getRegionZ()).withStyle(ChatFormatting.GRAY));
        mc.setScreen((Screen)screen);
    }

    private void generateArea(BlockPos pos) {
        Level level = this.getClientLevel();
        if (level == null) {
            return;
        }
        this.generationMarker.setFrom(level, pos);
        this.deletionMarker.clear();
    }

    private void processGenerator(DimensionPos generationMarker) {
        if (!generationMarker.canExecute()) {
            return;
        }
        ResourceKey<Level> dimension = generationMarker.dimension;
        BlockPos from = generationMarker.from();
        BlockPos to = generationMarker.to();
        Minecraft mc = Minecraft.getInstance();
        Screen current = mc.screen;
        ConfirmScreen screen = new ConfirmScreen(T -> {
            if (T) {
                ChunkPos pos = new ChunkPos(from);
                SquareAreaTask task = new SquareAreaTask("journeyMap_gen_area_" + pos.x + "_" + pos.z, dimension, GenerationType.NORMAL_GEN.ordinal(), pos, new ChunkPos(to));
                NetworkManager.INSTANCE.sendToServer(new CommandPacket.GenTask(task));
            }
            mc.setScreen(current);
        }, (Component)TextUtil.translate("journey.chunk_pregen.generator.header").withStyle(ChatFormatting.RED), (Component)TextUtil.translate("journey.chunk_pregen.generator.body", from.getX(), from.getZ(), to.getX(), to.getZ()).withStyle(ChatFormatting.GRAY));
        mc.setScreen((Screen)screen);
    }

    @SubscribeEvent
    public void onTaskStopped(PregenTaskEvent.Stopped event) {
        this.progressCache.remove(event.getTaskId());
    }

    @SubscribeEvent
    public void onTaskRemoved(PregenTaskEvent.Removed event) {
        this.progressCache.remove(event.getTask().getTaskId());
    }

    @SubscribeEvent
    public void onTasksCleared(PregenTaskEvent.Cleared event) {
        this.progressCache.clear();
    }

    @SubscribeEvent
    public void onTasksStopped(PregenTaskEvent.StoppedAll event) {
        this.progressCache.clear();
    }

    private LevelChunk toClientChunk(LevelChunk serverChunk, Level clientLevel) {
        ChunkPos pos = serverChunk.getPos();
        LevelChunk chunk = new LevelChunk(clientLevel, pos);
        ClientboundLevelChunkPacketData data = new ClientboundLevelChunkPacketData(serverChunk);
        chunk.replaceWithPacketData(data.getReadBuffer(), data.getHeightmaps(), data.getBlockEntitiesTagsConsumer(pos.x, pos.z));
        return chunk;
    }

    private static /* synthetic */ void lambda$deleteRegion$3(ChunkPos chunk, Level level, LongList output, Minecraft mc, Screen current, boolean T) {
        if (T) {
            NetworkManager.INSTANCE.sendToServer(new CommandPacket.DeletionTask(new DeletionSpecific("journeyMap_region_" + chunk.getRegionX() + "_" + chunk.getRegionZ(), (ResourceKey<Level>)level.dimension(), output)));
        }
        mc.setScreen(current);
    }

    private static class DimensionPos {
        String id;
        ResourceKey<Level> dimension;
        BlockPos from;
        BlockPos to;
        PolygonOverlay overlay;
        Listener listener = new Listener(this::onClick);
        Consumer<DimensionPos> result;

        public DimensionPos(String name, Consumer<DimensionPos> result) {
            this.id = name;
            this.result = result;
        }

        public void setFrom(Level level, BlockPos pos) {
            this.validateDimension(level);
            this.from = pos.immutable();
            this.updateMouse();
        }

        public void setTo(BlockPos pos) {
            this.to = pos.immutable();
            this.updateMouse();
            this.result.accept(this);
            this.clear();
        }

        public void updateMouse() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof Fullscreen) {
                Fullscreen full = (Fullscreen)screen;
                this.updateMap(full.getBlockAtMouse());
            }
        }

        private boolean onClick(int mouseClick) {
            if (this.overlay == null) {
                return true;
            }
            if (mouseClick == 1) {
                this.clear();
                return false;
            }
            if (mouseClick == 0) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof Fullscreen) {
                    Fullscreen full = (Fullscreen)screen;
                    this.setTo(full.getBlockAtMouse());
                }
                return false;
            }
            return true;
        }

        private void updateMap(BlockPos pos) {
            this.hide();
            if (this.from != null && this.to != null) {
                this.overlay = this.createOverlay(this.from, this.to);
            } else if (this.from != null) {
                this.overlay = this.createOverlay(this.from, pos);
            } else if (this.to != null) {
                this.overlay = this.createOverlay(pos, this.to);
            } else {
                return;
            }
            this.show();
        }

        private PolygonOverlay createOverlay(BlockPos from, BlockPos to) {
            ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(255).setStrokeOpacity(0.7f).setFillColor(65280).setFillOpacity(0.2f);
            PolygonOverlay overlay = new PolygonOverlay("journeymap", this.dimension, shapeProps, this.create(from, to));
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Fullscreen});
            overlay.setActiveMapTypes(Context.MapType.all());
            overlay.setOverlayListener((IOverlayListener)this.listener);
            overlay.setLabel(this.id);
            return overlay;
        }

        private String generateId(BlockPos from, BlockPos to) {
            return this.id + "_" + from.getX() + "_" + from.getZ() + "_" + to.getX() + "_" + to.getZ();
        }

        private MapPolygon create(BlockPos from, BlockPos to) {
            int minX = from.getX() < to.getX() ? from.getX() : to.getX();
            int minZ = from.getZ() < to.getZ() ? from.getZ() : to.getZ();
            int maxX = from.getX() > to.getX() ? from.getX() : to.getX();
            int maxZ = from.getZ() > to.getZ() ? from.getZ() : to.getZ();
            int y = 70;
            return new MapPolygon(new BlockPos[]{new BlockPos(minX, y, maxZ), new BlockPos(maxX, y, maxZ), new BlockPos(maxX, y, minZ), new BlockPos(minX, y, minZ)});
        }

        public boolean canExecute() {
            return this.from != null && this.to != null;
        }

        public BlockPos from() {
            return new BlockPos(this.from.getX() < this.to.getX() ? this.from.getX() : this.to.getX(), 70, this.from.getZ() < this.to.getZ() ? this.from.getZ() : this.to.getZ());
        }

        public BlockPos to() {
            return new BlockPos(this.from.getX() > this.to.getX() ? this.from.getX() : this.to.getX(), 70, this.from.getZ() > this.to.getZ() ? this.from.getZ() : this.to.getZ());
        }

        public void clear() {
            this.dimension = null;
            this.from = null;
            this.to = null;
            this.hide();
        }

        private void validateDimension(Level level) {
            if (Objects.equals(this.dimension, level.dimension())) {
                return;
            }
            this.dimension = level.dimension();
            this.from = null;
            this.to = null;
            this.hide();
        }

        private void show() {
            if (this.overlay == null) {
                return;
            }
            ClientAPI.INSTANCE.show((Displayable)this.overlay);
        }

        private void hide() {
            if (this.overlay == null) {
                return;
            }
            DataCache.INSTANCE.invalidatePolygon(this.overlay);
            ClientAPI.INSTANCE.remove((Displayable)this.overlay);
            this.overlay = null;
        }

        private static class Listener
        implements IOverlayListener {
            IntPredicate callback;

            public Listener(IntPredicate callback) {
                this.callback = callback;
            }

            public void onActivate(UIState paramUIState) {
            }

            public void onDeactivate(UIState paramUIState) {
            }

            public boolean onMouseClick(UIState arg0, Point2D.Double arg1, BlockPos arg2, int arg3, boolean arg4) {
                return this.callback.test(arg3);
            }

            public void onMouseMove(UIState arg0, Point2D.Double arg1, BlockPos arg2) {
            }

            public void onMouseOut(UIState arg0, Point2D.Double arg1, BlockPos arg2) {
            }

            public void onOverlayMenuPopup(UIState arg0, Point2D.Double arg1, BlockPos arg2, ModPopupMenu arg3) {
            }
        }
    }
}

