/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.plugins.journeyplugin.core;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.ImageHolder;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.client.properties.CoreProperties;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.client.texture.RegionTexture;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;

public class DeletionTask
implements Runnable {
    LongList list;
    ResourceKey<Level> level;

    public DeletionTask(LongList list, ResourceKey<Level> level) {
        this.list = list;
        this.level = level;
    }

    @Override
    public void run() {
        boolean biomeAllowed;
        JourneymapClient client = JourneymapClient.getInstance();
        CoreProperties props = client.getCoreProperties();
        boolean surfaceAllowed = FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        boolean cavesAllowed = FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        boolean topoAllowed = FeatureManager.getInstance().isAllowed(Feature.MapTopo) && props.mapTopography.get() != false;
        boolean bl = biomeAllowed = FeatureManager.getInstance().isAllowed(Feature.MapBiome) && props.mapBiome.get() != false;
        if (!(surfaceAllowed || cavesAllowed || topoAllowed || biomeAllowed)) {
            return;
        }
        EntityDTO player = DataCache.getPlayer();
        Entity playerEntity = (Entity)player.entityRef.get();
        if (playerEntity == null) {
            return;
        }
        ObjectArrayList maps = new ObjectArrayList();
        if (surfaceAllowed) {
            maps.add(MapType.day(this.level));
            maps.add(MapType.night(this.level));
        }
        if (cavesAllowed) {
            for (int i = -4; i < 16; ++i) {
                maps.add(MapType.underground((Integer)i, this.level));
            }
        }
        if (biomeAllowed) {
            maps.add(MapType.biome(this.level));
        }
        if (topoAllowed) {
            maps.add(MapType.topo(this.level));
        }
        ObjectLinkedOpenHashSet toValidate = new ObjectLinkedOpenHashSet();
        File file = FileHandler.getJMWorldDir((Minecraft)Minecraft.getInstance());
        int m = this.list.size();
        for (int i = 0; i < m; ++i) {
            ChunkPos pos = new ChunkPos(this.list.getLong(i));
            for (MapType type : maps) {
                RegionCoord rCoord = RegionCoord.fromChunkPos((File)file, (MapType)type, (int)pos.x, (int)pos.z);
                File map = RegionImageHandler.getRegionImageFile((RegionCoord)rCoord, (MapType)type);
                if (!map.exists()) continue;
                RegionDataStorageHandler.Key key = new RegionDataStorageHandler.Key(rCoord, type);
                RegionData regionData = RegionDataStorageHandler.getInstance().getRegionData(key);
                regionData.writeChunk(pos, null);
                RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
                ChunkMD md = new ChunkMD((LevelChunk)new EmptyLevelChunk(playerEntity.level(), pos, null));
                ComparableNativeImage cache = regionImageSet.getChunkImage(md, type);
                cache.fillRect(0, 0, 16, 16, 0);
                regionImageSet.setChunkImage(md, type, cache);
                toValidate.add(rCoord);
            }
        }
        RegionImageCache.INSTANCE.updateTextures(true, false);
        toValidate.parallelStream().forEach(arg_0 -> this.lambda$run$0((List)maps, arg_0));
    }

    private void deleteIfNeeded(RegionCoord coord, List<MapType> types) {
        RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(coord);
        for (MapType type : types) {
            ImageHolder holder = regionImageSet.getHolder(type);
            RegionTexture texture = holder.getTexture();
            if (!this.isInvisible(texture.getNativeImage())) continue;
            try {
                Files.deleteIfExists(RegionImageHandler.getRegionImageFile((RegionCoord)coord, (MapType)type).toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isInvisible(NativeImage image) {
        int m = image.getWidth();
        for (int x = 0; x < m; ++x) {
            int n = image.getWidth();
            for (int y = 0; y < n; ++y) {
                if (image.getLuminanceOrAlpha(x, y) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private /* synthetic */ void lambda$run$0(List maps, RegionCoord T) {
        this.deleteIfNeeded(T, maps);
    }
}

