/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.networking.NetworkManager;

public class CommandWrapper
implements CommandSource,
Consumer<Component> {
    CommandContext<CommandSourceStack> source;

    public CommandWrapper(CommandContext<CommandSourceStack> source) {
        this.source = source;
    }

    public boolean hasValue(String id, Class<?> type) {
        try {
            return this.source.getArgument(id, type) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T> T getOrDefault(String id, Class<T> type, T defaultValue) {
        try {
            return (T)this.source.getArgument(id, type);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public <T> T get(String id, Class<T> type) {
        return (T)this.source.getArgument(id, type);
    }

    public ResourceKey<Level> getDimension(String id) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.getOrDefault(id, ResourceLocation.class, this.getSource().getLevel().dimension().location()));
    }

    public void sendErrorMessage(Component component) {
        if (this.source != null) {
            ((CommandSourceStack)this.source.getSource()).sendFailure(this.ensureReadable(component));
        }
    }

    public void sendFeedBackMessage(Component component) {
        if (this.source != null) {
            ((CommandSourceStack)this.source.getSource()).sendSuccess(() -> this.ensureReadable(component), true);
        }
    }

    public CommandContext<CommandSourceStack> getContext() {
        return this.source;
    }

    public CommandSourceStack getSource() {
        return (CommandSourceStack)this.source.getSource();
    }

    public UUID getSenderId() {
        Entity entity = this.getSource().getEntity();
        return entity instanceof Player ? entity.getUUID() : null;
    }

    public String getTextName() {
        return this.getSource().getTextName();
    }

    public Component getName() {
        return this.getSource().getDisplayName();
    }

    private Component ensureReadable(Component comp) {
        return this.getSource().isPlayer() && !NetworkManager.INSTANCE.isInstalledOnClient(this.getSource().getPlayer()) ? TextUtil.serverTranslate(comp) : comp;
    }

    @Override
    public void accept(Component t) {
        this.sendSystemMessage(t);
    }

    public void sendSystemMessage(Component component) {
        if (this.source == null) {
            return;
        }
        ((CommandSourceStack)this.source.getSource()).sendSuccess(() -> this.ensureReadable(component), true);
    }

    public boolean acceptsSuccess() {
        return true;
    }

    public boolean acceptsFailure() {
        return true;
    }

    public boolean shouldInformAdmins() {
        return true;
    }
}

