/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.internal;

import carbonconfiglib.api.IConfigSerializer;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureCompound;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import pregenerator.common.utils.config.internal.DimensionSuggestion;

public class SpeedEntry {
    ResourceKey<Level> dim;
    float speed;

    public SpeedEntry() {
        this((ResourceKey<Level>)Level.OVERWORLD, 1.0f);
    }

    public SpeedEntry(ResourceKey<Level> dim, float speed) {
        this.dim = dim;
        this.speed = speed;
    }

    public ResourceKey<Level> getDimension() {
        return this.dim;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpeedEntry) {
            SpeedEntry entry = (SpeedEntry)obj;
            return Float.compare(this.speed, entry.speed) == 0 && Objects.equals(this.dim, entry.dim);
        }
        return false;
    }

    public ParsedCollections.ParsedMap serialize() {
        ParsedCollections.ParsedMap map = new ParsedCollections.ParsedMap();
        map.put("dimension", (Object)this.dim.location());
        map.put("speed", (Object)this.speed);
        return map;
    }

    public static List<SpeedEntry> getDefaultValues() {
        ObjectArrayList list = new ObjectArrayList();
        list.add(new SpeedEntry((ResourceKey<Level>)Level.OVERWORLD, 1.0f));
        list.add(new SpeedEntry((ResourceKey<Level>)Level.NETHER, 1.0f));
        list.add(new SpeedEntry((ResourceKey<Level>)Level.END, 1.0f));
        return list;
    }

    private static ParseResult<SpeedEntry> parse(ParsedCollections.ParsedMap map) {
        ParseResult location = map.getOrError("dimension", ResourceLocation.class);
        if (location.hasError()) {
            return location.onlyError();
        }
        ParseResult speed = map.getOrError("speed", Double.class);
        if (speed.hasError()) {
            return speed.onlyError();
        }
        return ParseResult.success((Object)new SpeedEntry((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)location.getValue())), ((Double)speed.getValue()).floatValue()));
    }

    private static void write(IWriteBuffer buffer, SpeedEntry entry) {
        buffer.writeString(entry.getDimension().location().toString());
        buffer.writeFloat(entry.getSpeed());
    }

    private static SpeedEntry read(IReadBuffer buffer) {
        return new SpeedEntry((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)buffer.readString())), buffer.readFloat());
    }

    public static IConfigSerializer<SpeedEntry> getSerializer() {
        StructureCompound.CompoundBuilder builder = new StructureCompound.CompoundBuilder();
        builder.variants("dimension", IStructuredData.EntryDataType.STRING, ResourceLocation.class, SpeedEntry::dimension, ResourceLocation::toString).addSuggestions(new ISuggestionProvider[]{DimensionSuggestion.INSTANCE}).finish();
        builder.simple("speed", IStructuredData.EntryDataType.DOUBLE).finish();
        return IConfigSerializer.withSync((StructureCompound.CompoundData)builder.build(), (Object)new SpeedEntry(), SpeedEntry::parse, SpeedEntry::serialize, SpeedEntry::read, SpeedEntry::write);
    }

    private static ParseResult<ResourceLocation> dimension(String parse) {
        ResourceLocation location = ResourceLocation.tryParse((String)parse);
        return location == null ? ParseResult.error((String)parse, (String)"First entry isn't in the ResourceLocation format") : ParseResult.success((Object)location);
    }
}

