/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class BiomeEntry
extends BaseWorldEntry {
    public BiomeEntry(FriendlyByteBuf buf) {
        super(buf);
    }

    public BiomeEntry(int id, int count) {
        super(id, count);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        Registry subRegistry = registry.registryOrThrow(Registries.BIOME);
        return subRegistry.getKey((Object)((Biome)subRegistry.byId(id)));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        Level level = chunk.getLevel();
        if (level instanceof ServerLevel) {
            BaseWorldEntry.Counter<Holder> counter = new BaseWorldEntry.Counter<Holder>();
            for (LevelChunkSection section : chunk.getSections()) {
                section.getBiomes().count(counter::add);
            }
            IdMap biome = ((ServerLevel)level).registryAccess().registryOrThrow(Registries.BIOME).asHolderIdMap();
            return counter.map((T, C) -> new BiomeEntry(biome.getId(T), C));
        }
        return ObjectLists.emptyList();
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return false;
    }

    @Override
    public int deleteWorld(WorldTracker tacker, Player player) {
        return 0;
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        return 0;
    }
}

