/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public class SyncStatePacket
implements IPregenPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncStatePacket> CODEC = CustomPacketPayload.codec(SyncStatePacket::write, IPregenPacket.readPacket(SyncStatePacket::new));
    public static final CustomPacketPayload.Type<SyncStatePacket> ID = IPregenPacket.createType("chunkpregen:state_sync");
    Dist source;

    public SyncStatePacket(Dist source) {
        this.source = source;
    }

    public SyncStatePacket(RegistryFriendlyByteBuf buffer) {
        this.source = buffer.readBoolean() ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.source.isClient());
    }

    @Override
    public void process(Player player) {
        NetworkManager.INSTANCE.onPlayerJoined(player, this.source.isClient());
        if (this.source.isClient()) {
            NetworkManager.INSTANCE.sendToPlayer(new SyncStatePacket(Dist.DEDICATED_SERVER), player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

