/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.RetrogenScreen;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.misc.PregenAction;

public class RetrogenPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, Request> REQUEST_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(Request::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Answer> ANSWER_CODEC = CustomPacketPayload.codec(Answer::write, IPregenPacket.readPacket(Answer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Change> CHANGE_CODEC = CustomPacketPayload.codec(Change::write, IPregenPacket.readPacket(Change::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Sync> SYNC_CODEC = CustomPacketPayload.codec(Sync::write, IPregenPacket.readPacket(Sync::new));
    public static final CustomPacketPayload.Type<Request> REQUEST = IPregenPacket.createType("chunkpregen:retrogen_request");
    public static final CustomPacketPayload.Type<Answer> ANSWER = IPregenPacket.createType("chunkpregen:retrogen_answer");
    public static final CustomPacketPayload.Type<Change> CHANGE = IPregenPacket.createType("chunkpregen:retrogen_change");
    public static final CustomPacketPayload.Type<Sync> SYNC = IPregenPacket.createType("chunkpregen:retrogen_sync");

    public static class Sync
    implements IPregenPacket {
        ResourceLocation location;
        boolean enable;

        public Sync(ResourceLocation location, boolean enable) {
            this.location = location;
            this.enable = enable;
        }

        public Sync(RegistryFriendlyByteBuf buffer) {
            this.location = buffer.readResourceLocation();
            this.enable = buffer.readBoolean();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.location);
            buffer.writeBoolean(this.enable);
        }

        @Override
        public void process(Player player) {
            if (this.enable) {
                RetrogenManager.INSTANCE.enableFeature(this.location);
            } else {
                RetrogenManager.INSTANCE.disableFeature(this.location);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return SYNC;
        }
    }

    public static class Change
    implements IPregenPacket {
        ResourceLocation location;
        boolean enable;

        public Change(ResourceLocation location, boolean enable) {
            this.location = location;
            this.enable = enable;
        }

        public Change(RegistryFriendlyByteBuf buffer) {
            this.location = buffer.readResourceLocation();
            this.enable = buffer.readBoolean();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.location);
            buffer.writeBoolean(this.enable);
        }

        @Override
        public void process(Player player) {
            if (ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                if (this.enable) {
                    RetrogenManager.INSTANCE.enableFeature(this.location);
                } else {
                    RetrogenManager.INSTANCE.disableFeature(this.location);
                }
                NetworkManager.INSTANCE.sendToAllPlayers(new Sync(this.location, RetrogenManager.INSTANCE.isActive(this.location)));
                return;
            }
            player.displayClientMessage((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
            NetworkManager.INSTANCE.sendToPlayer(new Sync(this.location, RetrogenManager.INSTANCE.isActive(this.location)), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CHANGE;
        }
    }

    public static class Answer
    implements IPregenPacket {
        Set<ResourceLocation> active = new ObjectLinkedOpenHashSet();
        Map<String, Map<String, List<ResourceLocation>>> mappedFeatures = new Object2ObjectLinkedOpenHashMap();

        public Answer(Set<ResourceLocation> active, Map<String, Map<String, List<ResourceLocation>>> mappedFeatures) {
            this.active.addAll(active);
            this.mappedFeatures.putAll(mappedFeatures);
        }

        public Answer(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.readCollection(buffer, this.active, FriendlyByteBuf::readResourceLocation);
            IPregenPacket.readMap(buffer, this.mappedFeatures, FriendlyByteBuf::readUtf, this::readModlist);
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.writeCollectionReverse(buffer, this.active, FriendlyByteBuf::writeResourceLocation);
            IPregenPacket.writeMap(buffer, this.mappedFeatures, FriendlyByteBuf::writeUtf, this::writeModList);
        }

        private void writeModList(RegistryFriendlyByteBuf buffer, Map<String, List<ResourceLocation>> entry) {
            IPregenPacket.writeMap(buffer, entry, FriendlyByteBuf::writeUtf, (K, V) -> IPregenPacket.writeCollectionReverse(K, V, FriendlyByteBuf::writeResourceLocation));
        }

        private Map<String, List<ResourceLocation>> readModlist(RegistryFriendlyByteBuf buffer) {
            Object2ObjectLinkedOpenHashMap result = new Object2ObjectLinkedOpenHashMap();
            IPregenPacket.readMap(buffer, result, FriendlyByteBuf::readUtf, B -> {
                ObjectArrayList list = new ObjectArrayList();
                IPregenPacket.readCollection(buffer, list, FriendlyByteBuf::readResourceLocation);
                return list;
            });
            return result;
        }

        @Override
        public void process(Player player) {
            RetrogenManager.INSTANCE.onSyncPacket(this.active);
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof RetrogenScreen) {
                ((RetrogenScreen)screen).receiveData(this.mappedFeatures);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER;
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        public Request() {
        }

        public Request(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new Answer(RetrogenManager.INSTANCE.getActiveFeatures(), RetrogenManager.INSTANCE.getAllMappedFeatures((RegistryAccess)ServerLifecycleHooks.getCurrentServer().registryAccess())), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST;
        }
    }
}

