/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import pregenerator.base.api.TextUtil;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public class MemoryPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestFree> REQUEST_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(RequestFree::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Answer> ANSWER_CODEC = CustomPacketPayload.codec(Answer::write, IPregenPacket.readPacket(Answer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestUsed> USED_CODEC = CustomPacketPayload.codec(RequestUsed::write, IPregenPacket.readPacket(RequestUsed::new));
    public static final CustomPacketPayload.Type<RequestFree> REQUEST = IPregenPacket.createType("chunkpregen:memory_request");
    public static final CustomPacketPayload.Type<Answer> ANSWER = IPregenPacket.createType("chunkpregen:memory_answer");
    public static final CustomPacketPayload.Type<RequestUsed> USED = IPregenPacket.createType("chunkpregen:memory_used");

    public static interface IMemoryReceiver {
        public void receivedMemory(ResourceKey<Level> var1, long var2, boolean var4);
    }

    public static class Answer
    implements IPregenPacket {
        ResourceKey<Level> dim;
        long memory;
        boolean free;

        public Answer(ResourceKey<Level> dim, long memory, boolean free) {
            this.dim = dim;
            this.memory = memory;
            this.free = free;
        }

        public Answer(RegistryFriendlyByteBuf buffer) {
            this.dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
            this.memory = buffer.readLong();
            this.free = buffer.readBoolean();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.dim.location());
            buffer.writeLong(this.memory);
            buffer.writeBoolean(this.free);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof IMemoryReceiver) {
                ((IMemoryReceiver)screen).receivedMemory(this.dim, this.memory, this.free);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER;
        }
    }

    public static class RequestUsed
    implements IPregenPacket {
        ResourceKey<Level> dim;

        public RequestUsed(ResourceKey<Level> dim) {
            this.dim = dim;
        }

        public RequestUsed(RegistryFriendlyByteBuf buffer) {
            this.dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.dim.location());
        }

        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new Answer(this.dim, TextUtil.getUsedMemory(this.dim), false), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return USED;
        }
    }

    public static class RequestFree
    implements IPregenPacket.IRequestPacket {
        public RequestFree() {
        }

        public RequestFree(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new Answer((ResourceKey<Level>)Level.OVERWORLD, TextUtil.getFreeMemory(), true), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST;
        }
    }
}

