/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.base.api.TextUtil;
import pregenerator.common.base.ProcessListener;
import pregenerator.common.commands.arguments.ISuggestableEnum;
import pregenerator.common.manager.ServerManager;

public class BenchmarkManager {
    public static final BenchmarkManager INSTANCE = new BenchmarkManager();
    List<BenchmarkResult> results = new ObjectArrayList();
    UUID sessionInstance = UUID.randomUUID();
    UUID starter = null;

    public boolean isBenchmarkRunning() {
        return this.starter != null;
    }

    public void interruptBenchmark() {
        this.starter = null;
        this.results.clear();
    }

    public void startBenchmark(UUID starter) {
        this.starter = starter;
    }

    public void addBenchmarkResult(long original, long chunks, Duration lightTime, Duration terrainChunk, boolean small, ResourceKey<Level> type) {
        if (this.starter == null || (double)chunks / (double)original < 0.75) {
            return;
        }
        this.results.add(new BenchmarkResult(original, chunks, lightTime.toMillis(), terrainChunk.toMillis(), small, type));
    }

    public void onBenchmarksFinished(Consumer<Component> listener) {
        ServerPlayer player;
        if (this.results.isEmpty() || this.starter == null) {
            this.starter = null;
            this.results.clear();
            return;
        }
        if (!ServerManager.INSTANCE.isListening(this.starter) && (player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(this.starter)) != null) {
            listener = listener.andThen(ProcessListener.create(this.starter)::sendMessage);
        }
        int lightScore = 0;
        int terrainScore = 0;
        long lightTime = 0L;
        long terrainTime = 0L;
        long chunks = 0L;
        for (BenchmarkResult result : this.results) {
            lightScore += result.lightScore();
            terrainScore += result.terrainScore();
            lightTime += result.lightTime;
            terrainTime += result.terrainTime;
            chunks += result.chunks;
        }
        listener.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.result"));
        listener.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.result.total", chunks, this.time(terrainTime), terrainScore, this.time(lightTime), lightScore));
        for (BenchmarkResult result : this.results) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.result.dimension", TextUtil.dimension(result.dim), chunks, this.time(terrainTime), terrainScore, this.time(lightTime), lightScore));
        }
        listener.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.result.info"));
        this.saveResults(listener);
        this.starter = null;
        this.results.clear();
    }

    private void saveResults(Consumer<Component> listener) {
        listener.accept((Component)TextUtil.translate("command.chunk_pregen.benchmark.result.saving"));
        Path path = ServerLifecycleHooks.getCurrentServer().getFile("Pregen_Benchmarks.json");
        JsonObject results = new JsonObject();
        try (BufferedReader reader2 = Files.newBufferedReader(path);){
            results = JsonParser.parseReader((Reader)reader2).getAsJsonObject();
        }
        catch (Exception reader2) {
            // empty catch block
        }
        JsonArray array = results.has("results") ? results.getAsJsonArray("results") : new JsonArray();
        results.add("results", (JsonElement)array);
        array.add((JsonElement)this.createUserData());
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            writer.setIndent(" ");
            Streams.write((JsonElement)results, (JsonWriter)writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JsonObject createUserData() {
        JsonObject obj = new JsonObject();
        obj.addProperty("seed", (Number)ServerManager.INSTANCE.getSeed());
        obj.addProperty("game_version", "1.19");
        obj.addProperty("starter", this.starter.toString());
        obj.addProperty("max_active_tasks", (Number)ServerManager.INSTANCE.getProcessors());
        obj.addProperty("agressive_pregen", Boolean.valueOf(true));
        obj.addProperty("allocated_ram", (Number)Runtime.getRuntime().maxMemory());
        JsonArray data = new JsonArray();
        for (BenchmarkResult result : this.results) {
            data.add((JsonElement)result.save());
        }
        obj.add("results", (JsonElement)data);
        data = new JsonArray();
        for (IModInfo info : ModList.get().getMods()) {
            data.add(info.getModId() + ";" + info.getVersion().toString().toLowerCase());
        }
        obj.add("mods", (JsonElement)data);
        return obj;
    }

    private String time(long value) {
        return DurationFormatUtils.formatDuration((long)value, (String)"HH:mm:ss");
    }

    public static class BenchmarkResult {
        long originalChunks;
        long chunks;
        long lightTime;
        long terrainTime;
        boolean small;
        ResourceKey<Level> dim;

        public BenchmarkResult(long originalChunks, long chunks, long lightTime, long terrainTime, boolean small, ResourceKey<Level> dim) {
            this.originalChunks = originalChunks;
            this.chunks = chunks;
            this.lightTime = lightTime;
            this.terrainTime = terrainTime;
            this.small = small;
            this.dim = dim;
        }

        public int terrainScore() {
            return (int)(this.terrainTime / this.chunks);
        }

        public int lightScore() {
            return (int)(this.lightTime / this.chunks);
        }

        public void write(DataOutputStream stream) throws IOException {
            stream.writeLong(this.originalChunks);
            stream.writeLong(this.chunks);
            stream.writeLong(this.terrainTime);
            stream.writeLong(this.lightTime);
            stream.writeBoolean(this.small);
            stream.writeUTF(this.dim.location().toString());
        }

        public JsonObject save() {
            JsonObject obj = new JsonObject();
            obj.addProperty("original_size", (Number)this.originalChunks);
            obj.addProperty("chunks", (Number)this.chunks);
            obj.addProperty("light_time", (Number)this.lightTime);
            obj.addProperty("terrain_time", (Number)this.terrainTime);
            obj.addProperty("dim", this.dim.location().toString());
            obj.addProperty("size", (Number)(this.small ? 40000 : 250000));
            obj.addProperty("light_score", (Number)this.lightScore());
            obj.addProperty("terrain_score", (Number)this.terrainScore());
            return obj;
        }
    }

    public static enum BenchmarkSize implements ISuggestableEnum
    {
        SMALL_TASK,
        LARGE_TASK;


        @Override
        public Component createSuggestion() {
            return TextUtil.translate(this == SMALL_TASK ? "command.chunk_pregen.benchmark.suggestion.small" : "command.chunk_pregen.benchmark.suggestion.big");
        }

        public boolean isSmall() {
            return this == SMALL_TASK;
        }

        public boolean isLarge() {
            return this == LARGE_TASK;
        }
    }
}

