/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class CircleTask
extends BaseTask {
    long center;
    int radius;

    public CircleTask(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.getLong("center");
        this.radius = nbt.getInt("radius");
    }

    public CircleTask(String name, ResourceKey<Level> type, int genType, ChunkPos center, int radius) {
        super(name, type, genType);
        this.center = center.toLong();
        this.radius = radius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.putLong("center", this.center);
        nbt.putInt("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.circle");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.circle"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.x, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.z, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.radius", this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        return (long)((double)(this.radius * this.radius) * Math.PI);
    }

    @Override
    public ChunkProcess createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        long diameter = (long)this.radius * 2L;
        progress.setMax(diameter * diameter);
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos center = new ChunkPos(this.center);
        process.init(ChunkShapeBuilder.getCircleShape(center.x, center.z, this.radius, progress), center, this.name, this.task, this.throwEvents, progress);
        return process;
    }
}

