/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import pregenerator.ChunkPregenerator;

public class RetrogenManager {
    public static final RetrogenManager INSTANCE = new RetrogenManager();
    Set<ResourceLocation> activeFeatures = new ObjectLinkedOpenHashSet();

    public Set<ResourceLocation> getInactiveFeatures(RegistryAccess access) {
        ObjectLinkedOpenHashSet locations = new ObjectLinkedOpenHashSet(this.getAllFeatures(access));
        locations.removeAll(this.activeFeatures);
        return locations;
    }

    public List<ResourceLocation> getAllFeatures(RegistryAccess access) {
        return new ObjectArrayList((Collection)access.registry(Registries.PLACED_FEATURE).map(Registry::keySet).orElse(Collections.emptySet()));
    }

    public Set<ResourceLocation> getActiveFeatures() {
        return new ObjectLinkedOpenHashSet(this.activeFeatures);
    }

    public Map<String, Map<String, List<ResourceLocation>>> getAllMappedFeatures(RegistryAccess access) {
        Registry registry = access.registryOrThrow(Registries.PLACED_FEATURE);
        Registry featureRegistry = access.registryOrThrow(Registries.FEATURE);
        Object2ObjectLinkedOpenHashMap result = new Object2ObjectLinkedOpenHashMap();
        ObjectArrayList sorted = new ObjectArrayList((Collection)registry.entrySet());
        sorted.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : sorted) {
            Map map = result.computeIfAbsent(((ResourceKey)entry.getKey()).location().getNamespace(), T -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
            map.computeIfAbsent(featureRegistry.getKey((Object)((ConfiguredFeature)((PlacedFeature)entry.getValue()).feature().value()).feature()).getPath(), T -> new ObjectArrayList()).add(((ResourceKey)entry.getKey()).location());
        }
        for (Map.Entry entry : result.entrySet()) {
            Object2ObjectLinkedOpenHashMap newValue = new Object2ObjectLinkedOpenHashMap();
            newValue.putAll((Map)entry.getValue());
            entry.setValue(newValue);
        }
        return result;
    }

    public void enableFeature(ResourceLocation location) {
        this.activeFeatures.add(location);
    }

    public void disableFeature(ResourceLocation location) {
        this.activeFeatures.remove(location);
    }

    public boolean isActive(ResourceLocation location) {
        return this.activeFeatures.contains(location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onSyncPacket(Set<ResourceLocation> active) {
        this.activeFeatures.clear();
        this.activeFeatures.addAll(active);
    }

    public void retrogenChunks(LevelChunk chunk, StaticCache2D<GenerationChunkHolder> chunks) {
        if (this.activeFeatures.isEmpty()) {
            return;
        }
        BlockPos pos = SectionPos.of((ChunkPos)chunk.getPos(), (int)chunk.getLevel().getMinSection()).origin();
        try {
            ServerLevel world = (ServerLevel)chunk.getLevel();
            WorldgenRandom sharedseedrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long i1 = sharedseedrandom.setDecorationSeed(world.getSeed(), pos.getX(), pos.getZ());
            ChunkGenerator generator = world.getChunkSource().getGenerator();
            WorldGenRegion region = new WorldGenRegion(world, chunks, ChunkPyramid.LOADING_PYRAMID.getStepTo(ChunkStatus.FULL), (ChunkAccess)chunk);
            Biome biome = (Biome)chunk.getNoiseBiome(pos.getX(), pos.getY(), pos.getZ()).value();
            for (GenerationStep.Decoration generationstage$decoration : GenerationStep.Decoration.values()) {
                try {
                    this.decorate(biome, generationstage$decoration, generator, (WorldGenLevel)region, i1, sharedseedrandom, pos);
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.forThrowable((Throwable)exception, (String)"Biome decoration");
                    crashreport.addCategory("Generation").setDetail("CenterX", (Object)chunk.getPos().x).setDetail("CenterZ", (Object)chunk.getPos().z).setDetail("Step", (Object)generationstage$decoration).setDetail("Seed", (Object)i1).setDetail("Chunk Pregenerator Gen", (Object)true);
                    throw new ReportedException(crashreport);
                }
            }
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.catching((Throwable)e);
        }
    }

    private void decorate(Biome biome, GenerationStep.Decoration stage, ChunkGenerator chunkGenerator, WorldGenLevel worldIn, long seed, WorldgenRandom random, BlockPos pos) {
        Registry registry = worldIn.getServer().registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
        int i = 0;
        for (Holder feature : (HolderSet)biome.getGenerationSettings().features().get(stage.ordinal())) {
            PlacedFeature configuredfeature = (PlacedFeature)feature.value();
            if (!this.activeFeatures.contains(registry.getKey((Object)configuredfeature))) {
                ++i;
                continue;
            }
            random.setFeatureSeed(seed, i, stage.ordinal());
            try {
                configuredfeature.placeWithBiomeCheck(worldIn, chunkGenerator, (RandomSource)random, pos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)exception, (String)"Feature placement");
                crashreport.addCategory("Feature").setDetail("Id", (Object)registry.getKey((Object)configuredfeature));
                throw new ReportedException(crashreport);
            }
            ++i;
        }
    }
}

