/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import pregenerator.base.api.TextUtil;
import pregenerator.common.commands.arguments.ISuggestableEnum;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkProcess;

public enum GenerationType implements ISuggestableEnum
{
    TERRAIN_ONLY(0){

        @Override
        public boolean hasSubTask() {
            return false;
        }
    }
    ,
    FAST_CHECK_GEN(1),
    NORMAL_GEN(2, true),
    POST_GEN(3, true),
    BLOCK_POST(4),
    RETROGEN(5, true){

        @Override
        public boolean hasSubTask() {
            return false;
        }

        @Override
        public void startMainTask(long[] chunks, CompletableFuture<ChunkResult<ChunkAccess>>[] tasks, ChunkEntry entry, ChunkProcess task) {
            task.startTask(chunks, 8, tasks);
            ObjectArrayList list = new ObjectArrayList();
            for (int i = 0; i < tasks.length; ++i) {
                ChunkPos pos = new ChunkPos(chunks[i]);
                for (int k = -8; k <= 8; ++k) {
                    for (int l = -8; l <= 8; ++l) {
                        list.add(task.getChunk(ChunkPos.asLong((int)(pos.x + l), (int)(pos.z + k))));
                    }
                }
            }
            entry.setRetrogenTask(CompletableFuture.allOf(list.toArray(new CompletableFuture[list.size()])));
        }

        @Override
        public void unloadMainTask(long[] chunks, int min, int max, ChunkProcess task) {
            task.finishTickets(chunks, min, max, 8);
        }

        @Override
        public void startSubTask(long[] chunks, CompletableFuture<ChunkResult<ChunkAccess>>[] tasks, ChunkProcess task) {
        }

        @Override
        public void unloadSubTask(long[] chunks, int min, int max, ChunkProcess task) {
        }
    };

    int index;
    boolean accurate;

    private GenerationType(int index, boolean accurate) {
        this.index = index;
        this.accurate = accurate;
    }

    private GenerationType(int index) {
        this.index = index;
        this.accurate = false;
    }

    public Component createText() {
        switch (this.ordinal()) {
            case 4: {
                return TextUtil.translate("task.chunk_pregen.gen_type.block_post").plainCopy();
            }
            case 1: {
                return TextUtil.translate("task.chunk_pregen.gen_type.fast_check_gen").plainCopy();
            }
            case 2: {
                return TextUtil.translate("task.chunk_pregen.gen_type.normal_gen").plainCopy();
            }
            case 3: {
                return TextUtil.translate("task.chunk_pregen.gen_type.post_gen").plainCopy();
            }
            case 5: {
                return TextUtil.translate("task.chunk_pregen.gen_type.retrogen").plainCopy();
            }
            case 0: {
                return TextUtil.translate("task.chunk_pregen.gen_type.terrain_only").plainCopy();
            }
        }
        return TextUtil.literal("I AM ERROR");
    }

    @Override
    public Component createSuggestion() {
        switch (this.ordinal()) {
            case 4: {
                return TextUtil.translate("task.chunk_pregen.gen_type.block_post.desc");
            }
            case 1: {
                return TextUtil.translate("task.chunk_pregen.gen_type.fast_check_gen.desc");
            }
            case 2: {
                return TextUtil.translate("task.chunk_pregen.gen_type.normal_gen.desc");
            }
            case 3: {
                return TextUtil.translate("task.chunk_pregen.gen_type.post_gen.desc");
            }
            case 5: {
                return TextUtil.translate("task.chunk_pregen.gen_type.retrogen.desc");
            }
            case 0: {
                return TextUtil.translate("task.chunk_pregen.gen_type.terrain_only.desc");
            }
        }
        return TextUtil.literal("I AM ERROR");
    }

    public int getIndex() {
        return this.index;
    }

    public boolean requiresAccurateScan() {
        return this.accurate;
    }

    public boolean hasSubTask() {
        return true;
    }

    public void startMainTask(long[] chunks, CompletableFuture<ChunkResult<ChunkAccess>>[] tasks, ChunkEntry entry, ChunkProcess task) {
        task.startTask(chunks, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.CARVERS : ChunkStatus.FEATURES, tasks);
    }

    public void startSubTask(long[] chunks, CompletableFuture<ChunkResult<ChunkAccess>>[] tasks, ChunkProcess task) {
        task.startTask(chunks, ChunkStatus.FULL, tasks);
        task.finishTickets(chunks, 0, chunks.length, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.CARVERS : ChunkStatus.FEATURES);
    }

    public void unloadMainTask(long[] chunks, int min, int max, ChunkProcess task) {
        task.finishTickets(chunks, min, max, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.CARVERS : ChunkStatus.FEATURES);
    }

    public void unloadSubTask(long[] chunks, int min, int max, ChunkProcess task) {
        task.finishTickets(chunks, min, max, ChunkStatus.FULL);
    }
}

