/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.misc.Area;

public enum ChunkLogger {
    Task{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            MutableComponent name = TextUtil.translate("process.chunk_pregen.name", processor.getTaskName()).withStyle(ChatFormatting.RED);
            MutableComponent shape = TextUtil.translate("process.chunk_pregen.shape", processor.getTask().getShapeName()).withStyle(ChatFormatting.GOLD);
            text.append((Component)1.wrap((Component)name)).append((Component)1.wrap((Component)shape));
        }
    }
    ,
    World{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.append((Component)2.wrap((Component)TextUtil.translate("task.chunk_pregen.dimension", TextUtil.dimension(processor.getTask().getDimension())).withStyle(ChatFormatting.GREEN))).append(" ");
            text.append((Component)2.wrap((Component)TextUtil.translate("process.chunk_pregen.task_type", processor.process.getTaskType().createText()).withStyle(ChatFormatting.DARK_AQUA)));
        }
    }
    ,
    TaskInfo{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            String terrain = IProcess.NUMBERS.format(processor.gen_speed.getLastValue());
            String light = IProcess.NUMBERS.format(processor.light_speed.getLastValue());
            String total = IProcess.NUMBERS.format(processor.process.getTotalChunks());
            text.append((Component)3.wrap((Component)TextUtil.translate(processor.isMultithreaded() ? "process.chunk_pregen.task_full" : "process.chunk_pregen.task_part", terrain, light, total).withStyle(ChatFormatting.BLUE)));
            if (processor.process.isValidating()) {
                text.append((Component)TextUtil.translate("process.chunk_pregen.logger_split"));
                long[] progress = processor.process.getValidationProgress();
                text.append((Component)3.wrap((Component)TextUtil.translate("process.chunk_pregen.validation", IProcess.NUMBERS.format(progress[0]), IProcess.NUMBERS.format(progress[1]))));
            }
        }
    }
    ,
    ProcessingSpeed{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            String main = IProcess.FLOATING_NUMBERS.format(processor.mainQueue.isNotWorking() && processor.process.isDone() ? 0.0 : (double)processor.gen_speed.getTotalValue());
            String light = IProcess.FLOATING_NUMBERS.format(processor.lightQueue.isNotWorking() ? 0.0 : (double)processor.light_speed.getTotalValue());
            text.append((Component)4.wrap((Component)TextUtil.translate(processor.isMultithreaded() ? "process.chunk_pregen.speed_full" : "process.chunk_pregen.speed_part", main, light).withStyle(ChatFormatting.AQUA)));
        }
    }
    ,
    LoadedFiles{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.append((Component)5.wrap((Component)TextUtil.translate("process.chunk_pregen.world_loaded_data", processor.process.getLoadedChunks(), processor.process.getActiveRegionFiles(), processor.process.getPointsOfInterest()).withStyle(ChatFormatting.GOLD)));
        }
    }
    ,
    workingArea{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            Area area = processor.lightQueue.getWorkingArea();
            if (area != null) {
                text.append((Component)6.wrap((Component)TextUtil.translate("process.chunk_pregen.working_area", area.getMinX(), area.getMinZ(), area.getMaxX(), area.getMaxZ()).withStyle(ChatFormatting.RED)));
            } else {
                text.append((Component)6.wrap((Component)TextUtil.translate("process.chunk_pregen.working_area.fetching").plainCopy().withStyle(ChatFormatting.RED)));
            }
        }
    }
    ,
    ExpectedTime{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            long total = processor.process.getTotalChunks();
            String main = this.getTime((long)((float)(total - processor.normalDone) / processor.gen_speed.getTotalValue()) * 50L);
            String light = this.getTime((long)((float)(total - processor.lightDone) / processor.light_speed.getTotalValue()) * 50L);
            text.append((Component)7.wrap((Component)TextUtil.translate(processor.isMultithreaded() ? "process.chunk_pregen.time_full" : "process.chunk_pregen.time_part", main, light, processor.getTime()).withStyle(ChatFormatting.GREEN)));
        }
    }
    ,
    RamUsage{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            ServerLevel level = processor.process.getWorld();
            text.append((Component)8.wrap((Component)TextUtil.ram().withStyle(ChatFormatting.LIGHT_PURPLE)));
            text.append((Component)8.wrap((Component)TextUtil.translate("process.chunk_pregen.ticks", level.getBlockTicks().count(), level.getFluidTicks().count()).withStyle(ChatFormatting.BLUE)));
        }
    }
    ,
    Controls{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            String pause = "/pregen pause " + processor.getTaskName();
            String resume = "/pregen resume " + processor.getTaskName();
            String unlisten = "/pregen info unlisten";
            String listen = "/pregen info listen";
            String stop = "/pregen stop " + processor.getTaskName();
            String cont = "/pregen continue " + processor.getTaskName();
            String delete = "/pregen stop " + processor.getTaskName() + " true";
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.listen").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, listen)).withColor(ChatFormatting.GREEN))));
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.mute").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, unlisten)).withColor(ChatFormatting.RED))));
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.pause").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pause)).withColor(ChatFormatting.AQUA))));
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.resume").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, resume)).withColor(ChatFormatting.BLUE))));
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.stop").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, stop)).withColor(ChatFormatting.YELLOW))));
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.continue").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cont)).withColor(ChatFormatting.DARK_AQUA))));
            text.append((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.remove").plainCopy().withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, delete)).withColor(ChatFormatting.GOLD))));
        }
    };


    public static MutableComponent wrap(Component text) {
        return TextUtil.translate("process.chunk_pregen.wrap", text);
    }

    protected String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)"HH:mm:ss");
    }

    public void append(MutableComponent text, ChunkProcessor processor) {
    }
}

