/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionSquare
extends BaseDeletionTask {
    long center;
    int radius;

    public DeletionSquare(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.getLong("center");
        this.radius = nbt.getInt("radius");
    }

    public DeletionSquare(String name, ResourceKey<Level> type, ChunkPos center, int radius) {
        super(name, type);
        this.center = center.toLong();
        this.radius = radius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.putLong("center", this.center);
        nbt.putInt("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.square");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.square"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.x, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.z, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.radius", this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        long diameter = (long)this.radius * 2L;
        return diameter * diameter;
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world);
        ChunkPos center = new ChunkPos(this.center);
        return deleter.init(ChunkShapeBuilder.getSquareShape(center.x, center.z, this.radius, progress), center, progress);
    }
}

