/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.command.EnumArgument;
import pregenerator.base.api.TextUtil;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.deleter.tasks.DeletionExcess;
import pregenerator.common.deleter.tasks.DeletionTimeOut;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;
import pregenerator.common.utils.misc.GenShape;

public class DeletionCommand {
    public static CommandBuilder createDeletionCommand(boolean advArgs) {
        CommandBuilder builder = new CommandBuilder("delete");
        Consumer<CommandWrapper> radius = DeletionCommand::executeRadius;
        builder.literal("radius");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.arg("Center", CenterArgument.center());
            builder.arg("Radius", RadiusArgument.integer(1, 25000), radius);
        } else {
            builder.arg("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)DeletionCommand::listShape));
            builder.arg("Center", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1, (int)25000), radius);
        }
        builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), radius).popTop();
        Consumer<CommandWrapper> expansion = DeletionCommand::executeExpansion;
        builder.literal("expansion");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.arg("Center", CenterArgument.center());
            builder.arg("Min Radius", RadiusArgument.integer(1));
            builder.arg("Max Radius", RadiusArgument.integer(1), expansion);
        } else {
            builder.arg("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)DeletionCommand::listShape));
            builder.arg("Center", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1));
            builder.arg("Max Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1), expansion);
        }
        builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), expansion).popTop();
        Consumer<CommandWrapper> trim = DeletionCommand::exececuteTrim;
        builder.literal("trim");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Center", CenterArgument.center());
            builder.arg("Min Radius", RadiusArgument.integer(1), trim);
        } else {
            builder.arg("Center", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1), radius);
        }
        builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), trim).popTop();
        Consumer<CommandWrapper> cleanup = DeletionCommand::executeCleanup;
        builder.literal("timedtrim");
        builder.arg("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.arg("Center", CenterArgument.center());
            builder.arg("Min Radius", RadiusArgument.integer(1));
        } else {
            builder.arg("Center", (ArgumentType<?>)ColumnPosArgument.columnPos(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.arg("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1));
        }
        builder.arg("Min Time", (ArgumentType<?>)TimeArgument.time(), cleanup);
        builder.arg("Dimension", (ArgumentType<?>)DimensionArgument.dimension(), cleanup).popTop();
        return builder;
    }

    private static CompletableFuture<Suggestions> listShape(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(GenShape.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString()));
        return builder.buildFuture();
    }

    private static void executeCleanup(CommandWrapper source) {
        String name = source.get("Task Name", String.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(source.get("Center", Coordinates.class), source.getSource());
        int radius = source.get("Min Radius", Integer.class);
        int timeOut = source.get("Min Time", Integer.class);
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (source.getSource().getServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startTask(new DeletionTimeOut(name, dimension, new ChunkPos(center.getX(), center.getZ()), radius, timeOut), source.getSenderId(), source);
    }

    private static void exececuteTrim(CommandWrapper source) {
        String name = source.get("Task Name", String.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(source.get("Center", Coordinates.class), source.getSource());
        int radius = source.get("Min Radius", Integer.class);
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (source.getSource().getServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startTask(new DeletionExcess(name, dimension, new ChunkPos(center.getX(), center.getZ()), radius), source.getSenderId(), source);
    }

    private static void executeRadius(CommandWrapper source) {
        String name = source.get("Task Name", String.class);
        GenShape shape = source.hasValue("Shape", String.class) ? GenShape.valueOf(source.get("Shape", String.class)) : source.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(source.get("Center", Coordinates.class), source.getSource());
        int radius = source.get("Radius", Integer.class);
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (source.getSource().getServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startTask(shape.createRadiusDeleteTask(name, center.getX(), center.getZ(), radius, dimension), source.getSenderId(), source);
    }

    private static void executeExpansion(CommandWrapper source) {
        int maxRadius;
        String name = source.get("Task Name", String.class);
        GenShape shape = source.hasValue("Shape", String.class) ? GenShape.valueOf(source.get("Shape", String.class)) : source.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(source.get("Center", Coordinates.class), source.getSource());
        int minRadius = source.get("Min Radius", Integer.class);
        if (minRadius > (maxRadius = source.get("Max Radius", Integer.class).intValue())) {
            source.sendErrorMessage((Component)TextUtil.minBiggerThenMax());
            return;
        }
        if (maxRadius * maxRadius - minRadius * minRadius > 1000000000) {
            source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.error.deletion_to_big"));
            return;
        }
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (source.getSource().getServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startTask(shape.createExpansionDeleteTask(name, center.getX(), center.getZ(), minRadius, maxRadius, dimension), source.getSenderId(), source);
    }
}

